#include <cstdlib>
#include <iostream>
#include <cmath>

using namespace std;

int main(int argc, char *argv[])
{
    double kappa=atof(argv[1]);
    long N=atoi(argv[2]);
    long leng=atoi(argv[3]);
    int i;
    double phi, p;
    
    srand(123456789);
    cout.precision(15);
    cout<<"# Chirikov-Standard-Abbildung     kappa="<<kappa<<endl;
    cout<<"# p,\t\tphi"<<endl;
    for (i=1; i<=N; i++) {
        // zufllige Startwerte
        phi=(double)rand()/(double)RAND_MAX*M_PI*2;
        p=(double)rand()/(double)RAND_MAX*M_PI*2-M_PI;
        cout<<"#"<<endl<<"#"<<endl<<"#new trajectory    p="<<p<<",   phi="<<phi<<endl;
        for (int j=1; j<=leng; j++) {
            double pt;
            pt=fmod(p+kappa/(2*M_PI)*sin(phi), 2*M_PI);
            phi=fmod(phi+p+kappa/(2*M_PI)*sin(phi), 2*M_PI);
            p=pt;
            cout<<p<<",\t\t"<<phi<<endl;
        }
    }    
    return EXIT_SUCCESS;
}
