#include <cstdlib>
#include <iostream>
#include <cmath>

#include "utils.h"
#include "integrate_ode.h"

using namespace std;

/*
    (c) 2005 by Jan Krieger  -- jan@jkrieger.de - www.jkrieger.de
    
    Dieses Programm integriert den Duffing-Oszillator schrittweise 
    mit verschiedenen Verfahren
*/

// Anzahl der Dimensionen
#define dimension 2

// Parameter des Oszillators
double r=0.15;
double a=0.3;
double omega=1;

// Startwerte fr x und xpunkt
double x0=-1;
double xd0=1;

// Integriere von t=0..tmax, in steps Schritten
double steps=100;
double tmax=100;
#define h (tmax/steps)


// Definiere die DGl des Duffing-Oszillators
void f(double* yout, double* y, double t) {
  yout[1]=y[2];                                  // x' = p
  yout[2]=-r*y[2]+y[1]-y[1]*y[1]*y[1]+a*cos(omega*t); // p'=-r*p+x^3+a*cos(w t)
}


/*
    Aufruf:
      duffing1 x0 x0d r a omega teps tmax
*/
int main(int argc, char *argv[])
{
    double* y0=vector(dimension);
    double* yout2=vector(dimension);
    double* yout4=vector(dimension);
    double* youte=vector(dimension);
    double t=0;
    
    x0=atof(argv[1]);
    xd0=atof(argv[2]);
    r=atof(argv[3]);
    a=atof(argv[4]);
    omega=atof(argv[5]);
    steps=atof(argv[6]);
    tmax=atof(argv[7]);
    
    // Startwerte setzen
    youte[1]=x0;
    youte[2]=xd0;
    yout2[1]=x0;
    yout2[2]=xd0;
    yout4[1]=x0;
    yout4[2]=xd0;
    cout.precision(15);
    
    cout<<"# Duffing-Oszillator,   r="<<r<<",\t a="<<a<<endl;
    cout<<"#                       h="<<h<<",\t omega="<<omega<<endl;
    cout<<"#                       x0="<<x0<<",\t xd0="<<xd0<<endl;
    cout<<"#                       tmax="<<tmax<<",\t steps="<<steps<<endl;
    cout<<"# t,\teuler_x,\teuler_xdot,\trk2_x,\trk2_xdot,\trk4_x,\trk4_xdot"<<endl;
    cout<<"#"<<endl;
    
    // Integration
    cout<<t<<",\t"<<youte[1]<<",\t"<<youte[2]<<",\t"<<yout2[1]<<",\t"<<yout2[2]<<",\t"<<yout4[1]<<",\t"<<yout4[2]<<endl;
    for(t=0; t<tmax; t=t+h) {
      v_copy(y0,youte);       
      euler_step(youte, y0, t, h, f);
      
      v_copy(y0,yout2);       
      rk2_step(yout2, y0, t, h, f);
      
      v_copy(y0,yout4);       
      rk4_step(yout4, y0, t, h, f);
      
      t=t+h;
      
      cout<<t<<",\t"<<youte[1]<<",\t"<<youte[2]<<",\t"<<yout2[1]<<",\t"<<yout2[2]<<",\t"<<yout4[1]<<",\t"<<yout4[2]<<endl;
    }
    v_free(y0);
    v_free(yout2);
    v_free(yout4);
    v_free(youte);
    
    
    return EXIT_SUCCESS;
}
