#include <cstdlib>
#include <iostream>
#include <cmath>

#include "utils.h"
#include "integrate_ode.h"

using namespace std;

/*
    (c) 2005 by Jan Krieger  -- jan@jkrieger.de - www.jkrieger.de
    
    Dieses Programm integriert die ODE
      y'(x) = y(x)
    mit der Methode von Euler, RK2 (Runge-Kutta) und RK4. Danach werden die
    Ergebnisse verglichen und so ausgegeben, dass sie in LaTeX-tabular ber-
    nommen werden knnen.
*/

#define dimension 2

void f(double* yout, double* y, double x) {
  yout[dimension]=y[dimension];
}

int main(int argc, char *argv[])
{
    double* y0=vector(dimension);
    double* yout=vector(dimension);
    double* yout4=vector(dimension);
    double* youte=vector(dimension);
    double h=1;
    double a=-1;
    double b=1;
    y0[dimension]=exp(a);
    cout.precision(10);
    for(h=1; h>0.0000001; h=h/10) {
      //cout<<endl<<endl<<"# Euler;   h="<<h<<endl;
      euler(youte, y0, a, b, h, f);
      //cout<<endl<<endl<<"# RK2;   h="<<h<<endl;
      rk2(yout, y0, a, b, h, f);
      //cout<<endl<<endl<<"# RK4;   h="<<h<<endl;
      rk4(yout4, y0, a, b, h, f);
      cout<<"$"<<h<<"$ &\t $"<<youte[1]<<"$ &\t $"<<yout[1]<<"$ &\t $"<<yout4[1]<<"$\\\\"<<endl;
    }
    cout<<"$"<<h<<"$ &\t $"<<youte[1]<<"$ &\t $"<<yout[1]<<"$ &\t $"<<yout4[1]<<"$\\\\"<<endl;
    v_free(y0);
    v_free(yout);
    v_free(yout4);
    v_free(youte);
    return EXIT_SUCCESS;
}
