/*
    Tools zur Simulation des Ising-Modells mit einem
    Metropolis-Monte-Carlo-Algorithmus
*/


#define ising_cpp
#include"ising.h"



// zeigt das Spin-Gitter auf dem Bildschirm an (im text-Modus!!!)
void show() {
  for (int i=0; i<N; i++) {
    for (int j=0; j<N; j++) {
      cout<<((lattice[i][j])?"> ":"< ");
    }
    cout<<endl;
  }
  cout<<endl;
  cout<<endl;
}


void printpos(int n) {
  for (int i=0; i<N; i++) {
    for (int j=0; j<N; j++) {
      cout<<n<<",\t"<<i<<",\t"<<j<<",\t"<<((lattice[i][j])?-1:1)<<endl;
    }
  }
  cout<<"#  "<<endl;
  cout<<"#  "<<endl;
}


// initialisiert das Spin-gitter mit einer zuflligen Anordnung
// von Spins
void init() {
  // Gitter erstellen
  lattice = new bool*[N]; // Zeiger auf Spalten allokieren
  lattice[0]=new bool[N*N]; // Spalten allokieren (N*N bools)
  for (int i=1; i<N; i++) { // Spaltenzeiger setzen
    lattice[i]=lattice[i-1]+N;
  }
  // Initialisieren
  for (int i=0; i<N; i++)
    for (int j=0; j<N; j++)
      lattice[i][j]=(rand() >= RAND_MAX/2.0);
}

// Speicher wieder freigeben
void freeall() {
  delete lattice[0];
  delete lattice;  
}





// berechnet einen Sweep, es wird also fr jeden Spin
// einmal geprft, ob er sich ndert (-> Metropolis-Algo)
void sweep() {
  // Iteriere ber alle Spins   
  for (int i=0; i<N; i++)
    for (int j=0; j<N; j++) {
      // neuen Spin erzeugen  
      bool newSpin=(rand() >= RAND_MAX/2.0);
      if (newSpin != lattice[i][j]){
        // berechne den Energieunterschied dE der 
        // zwei Konfigurationen 
        double dE=Elocal(i,j)-cB*Spin(i,j);
      	lattice[i][j]=newSpin;
      	dE = (Elocal(i,j)-cB*Spin(i,j))-dE;
      	
      	// Akzeptieren der neuen Konfiguration fr dE<=0
      	if (dE>0.0) {
        	// fr dE>0 wird der Spin mit der Wahrscheinlichkeit
        	// 1-exp(-beta*dE) verworfen
      	  if (rand()/(double)RAND_MAX > exp(-beta*dE))
      	    lattice[i][j]=!newSpin;
      	}
      }
    }
}


// berechnet die mittlere Magnetisierung des Systems
double magnetization() {
  double result=0;
  for (int i=0; i<N; i++)
    for (int j=0; j<N; j++) {
      result+=Spin(i,j);
    }
  return result/((double)N*N);
}

// berechnet die mittlere Energie pro Spin
double energy() {
  // Anteil der Magnetisierung     
  double result = 0;
  // Anteil der Spin-Spin-Kopplung
  for (int i=0; i<N; i++)
    for (int j=0; j<N; j++) {
      result+=Elocal(i,j)-cB*Spin(i,j);
    }
  return result/((double)N*N);
}





#undef ising_cpp

