/*
    Simulation des Ising-Modells mit einem
    Metropolis-Monte-Carlo-Algorithmus
*/
#include<iostream>
#include<cmath>
#include<fstream>
#include<string>
#include<ctime>

#include "ising.h"
using namespace std;


/* 
  gibt eine Hysterekurve des Ising-Modell aus. Dazu wird
  cB (das ext. Magnetfeld) von -bound bis bound in Schritten
  von db variiert. Die Reihenfolge ist folgende
    0      ->  bound
    bound  -> -bound
   -bound  ->  bound 
  Es wird ein N*N-Gitter simuliert. Insgesamt werden Nmean
  Konfigurationen erzeugt. Davon werden die ersten Nskip
  Konfigurationen nicht bercksichtigt, um dem System zu er-
  lauben einen typischen Zustand einzunehmen. 
   
  Aufruf mit:
           ising1 N Nmean Nskip beta cJ bound db
           ising1 50 500   50    1    4  2     0.1
*/
int main(int argc, char *argv[])
{
  // Zufallszahlgenerator initialisieren  
  srand(time(NULL));
  N=atoi(argv[1]);
  Nmean=atoi(argv[2]);
  Nskip=atoi(argv[3]);
  beta=atof(argv[4]);
  cJ=atof(argv[5]);
  bound=atof(argv[6]);
  db=atof(argv[7]);
  
  // Spins initalisieren
  init();
  
  double mag=0, energ=0;
  int count=0;
  for (cB=0.0; cB<=bound; cB+=db) {
    mag=0;
    energ=0;
    count=0;
    for (int n=0; n<Nmean; n++) {
      sweep();
      if (n>Nskip) {
        mag+=magnetization();
        energ+=energy();
        count++;
      }
    }
    cout<<cB<<"  "<<mag/count<<"  "<<energ/count<<endl;
  }
  for (cB=bound; cB>=-bound; cB-=db) {
    mag=0;
    energ=0;
    count=0;
    for (int n=0; n<Nmean; n++) {
      sweep();
      if (n>Nskip) {
        mag+=magnetization();
        energ+=energy();
        count++;
      }
    }
    cout<<cB<<"  "<<mag/count<<"  "<<energ/count<<endl;
  }
  for (cB=-bound; cB<=bound; cB+=db) {
    mag=0;
    energ=0;
    count=0;
    for (int n=0; n<Nmean; n++) {
      sweep();
      if (n>Nskip) {
        mag+=magnetization();
        energ+=energy();
        count++;
      }
    }
    cout<<cB<<"  "<<mag/count<<"  "<<energ/count<<endl;
  }
  
  sweep();
  
  freeall();
      
    //system("PAUSE");
    return EXIT_SUCCESS;
}
