/*
    Simulation des Ising-Modells mit einem
    Metropolis-Monte-Carlo-Algorithmus
*/
#include<iostream>
#include<cmath>
#include<fstream>
#include<string>
#include<ctime>

#include "ising.h"
using namespace std;


/* 
  gibt die Temperaturabhngigkeit verschiedener Gren aus.
  Die temperatur wird zwischen T0 und T1 variiert, in Schritten
  von dT. Es gilt beta=1/T. Die temperaur wird also in Einheiten
  con k_b angegeben.
  
  Es wird ein N*N-Gitter simuliert. Insgesamt werden Nmean
  Konfigurationen erzeugt. Davon werden die ersten Nskip
  Konfigurationen nicht bercksichtigt, um dem System zu er-
  lauben einen typischen Zustand einzunehmen. 
   
  Aufruf mit:
           ising1 N Nmean Nskip cJ cB T0 T1 dT
           ising1 50 500   50    1    4  2     0.1
*/
int main(int argc, char *argv[])
{
  // Zufallszahlgenerator initialisieren  
  srand(time(NULL));
  N=atoi(argv[1]);
  Nmean=atoi(argv[2]);
  Nskip=atoi(argv[3]);
  cJ=atof(argv[4]);
  cB=atof(argv[5]);
  double T0=atof(argv[6]);
  double T1=atof(argv[7]);
  double dT=atof(argv[8]);
  int mode=atoi(argv[9]);
  
  // Spins initalisieren
  
  double mag=0, energ=0;
  int count=0;
  cout<<"#  2D Ising Modell   ("<<N<<"*"<<N<<" Spins)"<<endl;
  cout<<"#       J="<<cJ<<endl;
  cout<<"#       B="<<cB<<endl;
  cout<<"#  Temperatur, beta, Magnetisierung, Energie"<<endl;
  init();
  for (double temp=T0; temp<=T1; temp+=dT) {
    beta=1/temp;  
    mag=0;
    energ=0;
    count=0;
    for (int n=0; n<Nmean; n++) {
      sweep();
      if (n>Nskip) {
        mag+=magnetization();
        energ+=energy();
        count++;
        if (mode==1) {
           system("cls");
           show();
           cout<<endl<<"beta="<<beta<<"\tT="<<temp<<"\tM="<<mag/count<<endl;
        }
      }
    }
    if (mode==0) {
       cout<<temp<<",  "<<beta<<",  "<<mag/count<<",  "<<energ/count<<endl;
    } 
  }
  freeall();
  return EXIT_SUCCESS;
}
