/*
    Simulation des Ising-Modells mit einem
    Metropolis-Monte-Carlo-Algorithmus
*/
#include<iostream>
#include<cmath>
#include<fstream>
#include<string>
#include<ctime>

#include "ising.h"
using namespace std;




/* 
  gibt die Magnetfeldabhngigkeit verschiedener Gren aus.
  Das ext. Magnetfeld wird zwischen B0 und B1 variiert, in Schritten
  von dB. 
  
  Es wird ein N*N-Gitter simuliert. Insgesamt werden Nmean
  Konfigurationen erzeugt. Davon werden die ersten Nskip
  Konfigurationen nicht bercksichtigt, um dem System zu er-
  lauben einen typischen Zustand einzunehmen. 
  
  mode=0: Ausgabe der Werte als Tabelle
  mode=1: Anzeige des Spingitters im Textmodus
  mode=2: Ausgabe einiger Spins mit Koordinaten und Einstellung
   
  Aufruf mit:
           ising3 N Nmean Nskip beta cJ B0 B1 dB mode
*/
int main(int argc, char *argv[])
{
  // Zufallszahlgenerator initialisieren  
  srand(time(NULL));
  N=atoi(argv[1]);
  Nmean=atoi(argv[2]);
  Nskip=atoi(argv[3]);
  beta=atof(argv[4]);
  cJ=atof(argv[5]);
  double B0=atof(argv[6]);
  double B1=atof(argv[7]);
  double dB=atof(argv[8]);
  int mode=atoi(argv[9]);
  
  // Spins initalisieren
  
  double mag=0, energ=0;
  int count=0;
  cout<<"#  2D Ising Modell   ("<<N<<"*"<<N<<" Spins)"<<endl;
  cout<<"#       beta="<<beta<<endl;
  cout<<"#       J="<<cJ<<endl;
  if (mode!=2) cout<<"#  cB, Magnetisierung, Energie"<<endl;
  init();
  for (cB=B0; cB<=B1; cB+=dB) {
    mag=0;
    energ=0;
    count=0;
    for (int n=0; n<Nmean; n++) {
      sweep();
      if (n>Nskip) {
        mag+=magnetization();
        energ+=energy();
        count++;
        if (mode==1) {
           system("cls");
           show();
           cout<<endl<<"B="<<cB<<"\tM="<<mag/count<<endl;
        }
        if (mode==2) {
           printpos(n);   
        }
      }
    }
    if (mode==0) {
       cout<<cB<<",  "<<mag/count<<",  "<<energ/count<<endl;
    } 
  }
  freeall();
  return EXIT_SUCCESS;
}
