set terminal png enhanced font arial 10 size 600,400
set output "../logmap_feige_s.png"
set notitle
set key below
f(r,x)=4*r*x*(1-x)
f2(r,x)=f(r,f(r,x))
f3(r,x)=f(r,f(r,f(r,x)))
f4(r,x)=f2(r,f2(r,x))
f5(r,x)=f3(r,f2(r,x))
f6(r,x)=f3(r,f3(r,x))

plot [0.85:1][0:1] "lm.dat" notitle with dots,\
                   f(x,0.5), \
                   f2(x,0.5) title "f^{(2)}(x,0.5)", \
                   f3(x,0.5) title "f^{(3)}(x,0.5)", \
                   f4(x,0.5) title "f^{(4)}(x,0.5)", \
                   f5(x,0.5) title "f^{(5)}(x,0.5)", \
                   f6(x,0.5) title "f^{(6)}(x,0.5)" , \
                   0.5 notitle lt -1
set terminal win
set output "a"
replot
