#include <cstdlib>
#include <iostream>
#include <cmath>

#include "utils.h"
#include "integrate_ode.h"

using namespace std;

/*
    (c) 2005 by Jan Krieger  -- jan@jkrieger.de - www.jkrieger.de
    
    Dieses Programm integriert den Duffing-Oszillator schrittweise 
    mit verschiedenen Verfahren
*/

// Anzahl der Dimensionen
#define dimension 3

// Parameter des Systems
double sigma, r, b;


// Startwerte fr x,y,z
double xstart, ystart, zstart;

// Integriere von t=0..tmax, in steps Schritten
double steps;
double tmax;
#define h (tmax/steps)


// Definiere die DGl des Duffing-Oszillators
void f(double* yout, double* y, double t) {
  yout[1]=sigma*(y[2]-y[1]);
  yout[2]=r*y[1]-y[2]-y[1]*y[3];
  yout[3]=-b*y[3]+y[1]*y[2];
}


/*
    Aufruf:
      lorenz xstart ystart zstart sigma r b teps tmax
      
*/
int main(int argc, char *argv[])
{
    double* y=vector(dimension);
    double* yout=vector(dimension);
    double t=0;
    
    xstart=atof(argv[1]);
    ystart=atof(argv[2]);
    zstart=atof(argv[3]);
    sigma=atof(argv[4]);
    r=atof(argv[5]);
    b=atof(argv[6]);
    steps=atof(argv[7]);
    tmax=atof(argv[8]);
    
    // Startwerte setzen
    yout[1]=xstart;
    yout[2]=ystart;
    yout[3]=zstart;
    cout.precision(15);
    
    cout<<"# Lorenz-System,        r="<<r<<",\t b="<<b<<endl;
    cout<<"#                       h="<<h<<",\t sigma="<<sigma<<endl;
    cout<<"#                       xstart="<<xstart<<",\t ystart="<<ystart<<",\t zstart="<<zstart<<endl;
    cout<<"#                       tmax="<<tmax<<",\t steps="<<steps<<endl;
    cout<<"# t,\tx,\ty,\tz"<<endl;
    cout<<"#"<<endl;
    
    // Integration
    cout<<t<<",\t"<<yout[1]<<",\t"<<yout[2]<<",\t"<<yout[3]<<endl;
    for(t=0; t<tmax; t=t+h) {
      v_copy(y,yout);       
      rk4_step(yout, y, t, h, f);
      
      t=t+h;
      
      cout<<t<<",\t"<<yout[1]<<",\t"<<yout[2]<<",\t"<<yout[3]<<endl;
    }
    v_free(y);
    v_free(yout);
    
    
    return EXIT_SUCCESS;
}
