unset multiplot
reset
set terminal png  giant size 1000,800
set output "../lorenz2.png"
set nokey
set notitle
r=28
b=2.6667
sigma=10
chi=1;
a=1;
DeltaT=1;
T0=0;
height=1;
set isosamples 100,100

# 50.0009999999742,	8.90158336045107,	11.9829797481461,	23.238053557108

XT=8.90158336045107
YT=11.9829797481461
ZT=23.238053557108

psi(x,z)=chi*sqrt(2)/(2*b)*XT *sin(pi*a*x)*sin(pi*z)
theta(x,z)=DeltaT/pi*r*(sqrt(2)*XT*cos(pi*a*x)*sin(pi*x)-ZT*sin(2*pi*z))
T(x,z)=T0+DeltaT*(1-z/height)+theta(x,z)
u(x,z)=-chi*sqrt(2)/(2*b)*XT*pi*cos(pi*z)
v(x,z)=chi*sqrt(2)/(2*b)*XT*pi*a*cos(pi*a*z)

set pm3d map
set xlabel "x"
set ylabel "z"
set multiplot
splot [-10:10][0:height] T(x,y)
unset pm3d
plot [-10:10][0:height] "lorenz1_vel.dat" using 1:2:($3/100):($4/100) with vectors head filled lt 2
unset multiplot
set terminal win
set output "a"
replot
