#include <cstdlib>
#include <iostream>
#include <cmath>

#include "utils.h"
#include "integrate_ode.h"

using namespace std;

/*
    (c) 2005 by Jan Krieger  -- jan@jkrieger.de - www.jkrieger.de
    
    Dieses Programm Berechnet das Geschwindigkeitsfeld des Lorenz-Systems
*/


// Parameter des Systems
double sigma=10;
double r=28;
double b=2.6667;
double chi=1;
double a=1;
double DeltaT=1;
double T0=0;
double height=1;
double pi=M_PI;

double XT=8.90158336045107;
double YT=11.9829797481461;
double ZT=23.238053557108;

double u(double x, double z) {
  return -chi*sqrt(2)/(2*b)*XT*pi*cos(pi*z)*sin(pi*a*x);
}

double v(double x, double z) {
  return chi*sqrt(2)/(2*b)*XT*pi*a*cos(pi*a*z)*sin(pi*z);
}


/*
    Aufruf:
      lorenz_velocity

    Parameter werden direkt im Code eingestellt
      
*/
int main(int argc, char *argv[])
{
    for (double x=-100; x<=100; x+=1) {
        for (double z=0; z<=height; z+=.1){
            cout<<x<<",\t"<<z<<",\t"<<u(x,z)<<",\t"<<v(x,z)<<endl;
        }
    }
    
    return EXIT_SUCCESS;
}
