#include <cstdlib>
#include <iostream>
#include <cmath>

using namespace std;

#define a 16807
#define q 127773
#define r 2836
#define m 2147483647

// Park-Miller-Zufallszahlgenerator mit float-Rckgabe [0..1]
float ran_mcg(long *state) {
  *state=a * ( (*state) % q )- r*(*state)/q;
  if ((*state)<0) *state=*state + m;
  return *state/((float)m);
}

// Park-Miller-Zufallszahlgenerator mit long-Rckgabe [0..m]
long ran_mcgl(long *state) {
  *state=a * ( (*state) % q )- r*(*state)/q;
  if ((*state)<0) *state=*state + m;
  return *state;
}

// Park-Miller-Zufallszahlgenerator mit long-Rckgabe [0..m]
long ran_lcgl(long *state) {
  *state=(106*(*state)+1283) % 6075;
  return *state;
}

// Lnge der Misch-Tabelle
#define NTAB 32
long ran_mcg_mix(long *state, bool init=false) {
  static long mixtable[NTAB]; // static heit, das Array bleibt 
                              // zwischen zwei Funktionsaufrufen 
                              // erhalten
  long x, temp;
  int j;

  if (init) {                 // initialisiere die Tabelle
     for (int j=NTAB+7; j>=0; j--) {
       x=ran_lcgl(state);
       if (j<NTAB) mixtable[j]=x; // Befllen nach 8 "Aufwrmrunden"
     }
  }
  
  x=ran_lcgl(state);           // Zufallszahl ziehen
  j=x % NTAB;                  // j aus [0..NTAB-1]

  temp=mixtable[j];            // mischen
  mixtable[j]=x;

  return temp;
}

int main(int argc, char *argv[])
{
    int N=atoi(argv[1]);
    long *s=new long;
    int mode=atoi(argv[2]);
    *s=125896;
    ran_mcg_mix(s,true);
    float x;
    for (int i=0; i<N; i++) {
      if (mode==2) {
         x=ran_mcg_mix(s);
        cout<<x<<",\t";
      }
      if ((mode==1)||(mode==2)) {
        x=ran_mcg_mix(s);
        cout<<x<<",\t";
        x=ran_mcg_mix(s);
        cout<<x<<endl;
      }
      if (mode==4) {
         x=ran_lcgl(s);
        cout<<x<<",\t";
      }
      if ((mode==3)||(mode==4)) {
        x=ran_lcgl(s);
        cout<<x<<",\t";
        x=ran_lcgl(s);
        cout<<x<<endl;
      }
    }
    return EXIT_SUCCESS;
}
