unit JKEStructs;

interface

uses SysUtils;

const
  FileIDold:string[5]= 'JKEXP';
  FileID03:string[5]= 'JKE03';
  FileID31:string[5]= 'JKE31';

type
  tJKEFormat=     (expHTML, expTXT, expRTF, expLATEX, expLATEXtheBIB, expWinWord, expWinWordNew);
  tVn_NN=         (Vn_Nn, Nn_Vn);
  tJKENumber=     (jnFirst, jnSecond);
  //tJKEAlign=      (jalLeft,jalCenter,jalRight,jalBlock);
  tJKAlign=(alleft, alcenter, alright, aldef, alblock, alNone);      {-> alignments in HTML-file}
  tJKEFontStyle=  set of (jfsItalic,jfsBold,jfsSub,jfsSuper,jfsUnderlined,jfsDoubleUL);
  tJKEListStyle=  (jlsNumber, jlsCircle, jlsDash);

  tJKEDLLVersion=record
    autor:string[75];
    name:string[50];
    version:string[10];
    copyright:string[75];
    datum:string[10];
  end;

  tJKEFile=record
    name:shortString;
    title:shortstring;
    f:system.text;
  end;

  tJKEBedingung = packed record
    Feld,Parameter:string[50];
    Bedingung:string[11];
  end;
  tJKEBedingungold= packed record
    Feld,Bedingung,Parameter:string[100];
  end;

  pJKEBefehlold=^tJKEBefehlold;
  tJKEBefehlold = packed record
    Befehl:string[30];
    bedingung:Array[0..2] of tJKEBedingung;
    beding_link:ARRAY[0..1] of string[5];
    Parameter:ARRAY[0..19] of string[20];
    bold,italic,underlined:boolean;
    align:string[7];
  end;

  pJKEBefehl30=^tJKEBefehl30;
  tJKEBefehl30 = packed record
    Befehl:string[30];
    bedingung:Array[0..2] of tJKEBedingung;
    beding_link:ARRAY[0..1] of string[5];
    Parameter:ARRAY[0..19] of string[20];
    bold,italic,underlined:boolean;
    align:string[7];
    size:longint;
  end;

  pJKEBefehl31=^tJKEBefehl31;
  tJKEBefehl31 = packed record
    Befehl:string[30];
    bedingung:Array[0..2] of tJKEBedingung;
    beding_link:ARRAY[0..1] of string[5];
    Parameter:ARRAY[0..19] of string[20];
    bold,italic,underlined, subscript, superscript:boolean;
    align:string[7];
    size:longint;
  end;

  tJKFS=(italic,bold,underlined,sstrike,big,small,sub,super,hidden,shadow);
  tJKFontStyle=set of tJKFS;            {-> font styles,   select 1 or more}

  pCountRec = ^tCountRec;
  tCountRec=record
    name1,name2,name3:string;
    jahr, dsetnum, befnum:Longint;
  end;

implementation

end.
