{Unit to write HTML 3.2 files.

     +------------------------------------------------+
     |      Copyright (c) 1998 by Jan W. Krieger      |
     +------------------------------------------------+

 I sat down to write this unit to export datasets from a database-application into HTML
 Dokuments. Ihope, that anyone, who'l find a bug in this listing, would tell me via
 email: Ute.KKrieger@ws.tum.de (my mother's email, but I can use it too). If anybody likes
 this unit I would be happy to receive a message from him/her, too.

 If you need to change anything and you'll need the specification of HTML 3.5 (and as 4.0),
 you can get a great Documentation from 'W3C'. You can download it from the Webpage:
         www.w3.org/pub/WWW/TR/          --> it's a list of many files
         www.w3.org/TR/REC-html32.html   --> the documentation it self.


 THIS UNIT IS --== F R E E W A R E ==--, SO NO WARANTIES OF ANY KIND CAN BE MADE!!!

 Well, much fun writing HTML-files, Jan Krieger (17), Munich, Germany

 PS: excuse my sometimes really bad english...  :-( }

unit html10;
interface
uses classes, sysutils, JKEStructs;
type tHTMColor=(black,silver,gray,white,maroon,red,purple,fuchsia,green,lime,olive,yellow,navy,blue,teal,aqua);
                                                     {-> colors for use in HTML-files}
     tHTMCapAlign=(altop,albottom);                  {-> alignments in Tables}
     tHTMUItemStyle=(disc,square,circle);     {disc:   filled circle
                                               square: filled square
                                               circle: unfilled circle}
     tHTMOItemStyle=(arabic,lowChar, upChar,lowRom, upRom);     {arabic:   1,2,3...
                                                                 lowChar:  a,b,c...
                                                                 upChar:   A,B,C...
                                                                 lowRom:   i,ii,iii...
                                                                 upRom:    I,II,III...}
     tHTMListKind=(unordered,ordered,definition);  {-> Listentypen}

const HTMDefaultAlign=alleft;         {-> default alignment}
      HTMDefaultItemStyle=disc;       {-> default List item style}

function  HTMCol2Str(col:THTMColor;default:string):string;  {-> converts a color (col) to a string}
function  HTMAlign2Str(align:TJKAlign;default:string):string;  {-> converts an align to a string}
function  HTMUIStyle2Str(item:tHTMUItemStyle;default:string):string;  {-> converts an listitemstyle to a string}
function  HTMOIStyle2Str(item:tHTMOItemStyle;default:string):string;  {-> converts an listitemstyle to a string}
function  HTMFormatFileLink(filename:string):string;  {-> returns an string to be used in the HTMWrite(Ln)Link procedure,
                                                          which contains the filename in the right format}
function  HTMFormatFileALink(filename,anchor:string):string;  {-> same as HTMFormatFileLink but adds an link to a certain
                                                                  anchor in the aimed file}

procedure HTMOpen(fn,titel:string;bgCol,tcol:THTMColor);  {-> opens the HTML file and sets the title, background and textcolor}
procedure HTMClose;  {-> closes the HTML file}

procedure HTMHeading(heading:char;text:string);  {-> writes some Text in an certain Heading ('1'..'6')}
procedure HTMParagraph(align:TJKAlign;lines:TStrings);  {-> writes some lines of Text in certain alignment}
procedure HTMSetAlign(align:TJKAlign);
procedure HTMWriteLn(align:TJKAlign;style:tJKFontStyle;line:String);  {-> Writes some Text (with linebreak) in certain align
                                                                            and style}
procedure HTMSpace(n:integer);  {-> write n spaces}
procedure HTMWrite(style:tJKFontStyle;line:String);  {-> Writes somef Text (without linebreak) in certain
                                                                          align and style}

procedure HTMWriteRaw(text:string);
procedure HTMLineBreak;  {-> sets a linebreak tag}
procedure HTMLine(width,height:LongInt;percent:boolean;align:TJKAlign;shadow:Boolean); {-> writes a line
                                                                                         widht: in percent [1..100] if percent=
                                                                                                   true
                                                                                                in pixels [1..maxLongInt] if
                                                                                                   percent=false
                                                                                                (length of the line)
                                                                                         height in pixels (height of the Line)
                                                                                         align alignment of Line
                                                                                         shadow true: 3D shadow is added
                                                                                                false no 3D shadow is added}

procedure HTMDefAnchor(name:string);  {-> defines an Anchor at that point of the documnet}
procedure HTMWriteLink(name,title:string;align:TJKAlign;style:tJKFontStyle); {-> adds a link to name (no linebreak): URL,
                                                                               anchor name, or file:  see HTMFormatFileLink}
procedure HTMWriteLnLink(name,title:string;align:TJKAlign;style:tJKFontStyle); {-> adds a link to name (linebreak): URL,
                                                                                 anchor name, or file:  see HTMFormatFileLink}

procedure HTMOpenList(kind:tHTMListKind;compact:Boolean);{begins a List of kind and with/without compacted space between items}
procedure HTMUListItem(text:string;Lstyle:tHTMUItemStyle); {adds a listitem, unordred list, only}
procedure HTMOListItem(text:string;Lstyle:tHTMOItemStyle); {adds a listitem, ordred list, only}
procedure HTMDefListItem(term,definition:string); {adds a listitem, definition list, only}
procedure HTMCloseList(kind:tHTMListKind);  {closes a List}

procedure HTMImage(URL,PicReplace:string;border,left,top:LongInt);
          {-> adds an image (URL), with border (Pixel), top/left (Pixel)
              PicReplace: Text shown instead of Picture!!!}

procedure HTMOpenTable(align:tJKAlign;width:LongInt;percent:Boolean;border,cellspacing,cellpadding:LongInt;caption:string;
                       capAlign:tHTMCapAlign); {-> adds Table}
procedure HTMHeaderRow(items:TStrings); {adds a new header row to an existing Table}
procedure HTMRow(items:TStrings); {adds a new "normal" row to an existing Table}
procedure HTMNewRow;
procedure HTMNewHeaderCell;
procedure HTMNewCell;
procedure HTMCloseTable; {-> closes Table}
function  HTMInternString(s:string):string;  {-> internationalise a string}


implementation
var htmf:system.text;  {-> the HTML file variable}
    momalign:TJKAlign;

function HTMCol2Str(col:THTMColor;default:string):string;
begin
  case col of
    black: result:='black';
    silver: result:='silver';
    gray: result:='gray';
    white: result:='white';
    maroon: result:='maroon';
    red: result:='red';
    purple: result:='purple';
    fuchsia: result:='fuchsia';
    green: result:='green';
    lime: result:='lime';
    yellow: result:='yellow';
    navy: result:='navy';
    blue: result:='blue';
    teal: result:='teal';
    aqua: result:='aqua';
    else result:=default;
  end;
end;

function HTMAlign2Str(Align:TJKAlign;default:string):string;
begin
  if align=aldef then align:=HTMDefaultAlign;
  case align of
    alleft: result:='left';
    alcenter: result:='center';
    alright: result:='right';
    else result:=default;
  end;
end;

function HTMUIStyle2Str(item:tHTMUItemStyle;default:string):string;
begin
  case item of
    disc: result:='disc';
    square: result:='square';
    circle: result:='circle';
    else result:=default;
  end;
end;

function HTMOIStyle2Str(item:tHTMOItemStyle;default:string):string;
begin
  case item of
    arabic: result:='1';
    lowChar: result:='a';
    upChar: result:='A';
    lowRom: result:='i';
    upRom: result:='I';
    else result:=default;
  end;
end;

function  HTMFormatFileLink(filename:string):string;
begin
  if copy(filename,2,1)=':' then result:='file:///'+copy(filename,1,1)+'|'+copy(filename,3,length(filename)-2)
  else if pos('\',filename)=0 then result:='..\'+filename
  else result:=filename;
end;

function  HTMFormatFileALink(filename,anchor:string):string;
begin
  if copy(filename,2,1)=':' then result:='file:///'+copy(filename,1,1)+'|'+copy(filename,3,length(filename)-2)+'#'+anchor
  else if pos('\',filename)=0 then result:='..\'+filename+'#'+anchor
  else result:=filename+'#'+anchor;
end;

procedure HTMOpen(fn,titel:string;bgCol,tcol:THTMColor);
var s:string;
begin
  AssignFile(htmf,fn);
  Rewrite(htmf);
  WriteLn(htmf,'<HTML>');
  WriteLn(htmf,'<HEAD>');
  WriteLn(htmf,'<TITLE>'+titel+'</TITLE>');
  s:='<BODY bgcolor='+HTMCol2Str(bgCol,'white')+' text='+HTMCol2Str(tcol,'black')+'>';
  WriteLn(htmf,s);
  momalign:=alleft;
end;

procedure HTMClose;
begin
  WriteLn(htmf,'</P>');
  WriteLn(htmf);
  WriteLn(htmf,'</BODY>');
  WriteLn(htmf,'</HTML>');
  CloseFile(htmf);
end;

procedure HTMWriteRaw(text:string);
begin
  writeLn(htmf,text);
end;

procedure HTMHeading(heading:char;text:string);
begin
  WriteLn(htmf,'<H'+heading+'>');
  WriteLn(htmf,HTMinternstring(text)+'</H'+heading+'>');
end;

procedure HTMSetAlign(align:TJKAlign);
begin
  WriteLn(htmf,'<P align='+HTMAlign2Str(align,'left')+'>');
  momalign:=align;
end;

procedure HTMParagraph(align:TJKAlign;lines:TStrings);
var i:longint;
begin
  WriteLn(htmf,'</P>');
  WriteLn(htmf,'<P align='+HTMAlign2Str(align,'left')+'>');
  momalign:=align;
  for i:=0 to lines.count-1 do
    writeLn(htmf,HTMinternstring(lines.strings[i])+' <BR>');
  WriteLn(htmf,'</P>');
end;

procedure HTMWriteLn(align:TJKAlign;style:tJKFontStyle;line:String);
begin
  if align<>momalign then begin
    WriteLn(htmf,'</P>');
    WriteLn(htmf,'<P align='+HTMAlign2Str(align,'left')+'>');
    momalign:=align;
  end;
  if italic in style then write(htmf,'<I>');
  if bold in style then write(htmf,'<B>');
  if underlined in style then write(htmf,'<U>');
  if sstrike in style then write(htmf,'<STRIKE>');
  if big in style then write(htmf,'<BIG>');
  if small in style then write(htmf,'<SMALL>');
  if sub in style then write(htmf,'<SUB>');
  if super in style then write(htmf,'<SUP>');
  write(htmf,HTMinternstring(line));
  if super in style then write(htmf,'</SUP>');
  if sub in style then write(htmf,'</SUB>');
  if small in style then write(htmf,'</SMALL>');
  if big in style then write(htmf,'</BIG>');
  if sstrike in style then write(htmf,'</STRIKE>');
  if underlined in style then write(htmf,'</U>');
  if bold in style then write(htmf,'</B>');
  if italic in style then write(htmf,'</I>');
  if align=momalign then writeLn(htmf,'<BR>');
end;

procedure HTMWrite(style:tJKFontStyle;line:String);
begin
  if italic in style then write(htmf,'<I>');
  if bold in style then write(htmf,'<B>');
  if underlined in style then write(htmf,'<U>');
  if sstrike in style then write(htmf,'<STRIKE>');
  if big in style then write(htmf,'<BIG>');
  if small in style then write(htmf,'<SMALL>');
  if sub in style then write(htmf,'<SUB>');
  if super in style then write(htmf,'<SUP>');
  write(htmf,HTMinternstring(line));
  if super in style then write(htmf,'</SUP>');
  if sub in style then write(htmf,'</SUB>');
  if small in style then write(htmf,'</SMALL>');
  if big in style then write(htmf,'</BIG>');
  if sstrike in style then write(htmf,'</STRIKE>');
  if underlined in style then write(htmf,'</U>');
  if bold in style then write(htmf,'</B>');
  if italic in style then write(htmf,'</I>');
end;

procedure HTMLineBreak;
begin
  WriteLn(htmf,'<BR>');
end;

procedure HTMLine(width,height:LongInt;percent:boolean;align:TJKAlign;shadow:Boolean);
begin
  Write(htmf,'<HR align='+HTMAlign2Str(align,'left'));
  if not shadow then Write(htmf,' noshade');
  Write(htmf,' size='+inttostr(height)+' width=');
  if percent then Write(htmf,'"'+inttostr(width)+'%"')
  else Write(htmf,inttostr(width));
  WriteLn(htmf,'>');
end;

procedure HTMDefAnchor(name:string);
begin
  WriteLn(htmf,'<A name="'+name+'"></A>');
end;

procedure HTMWriteLink(name,title:string;align:TJKAlign;style:tJKFontStyle);
begin
  WriteLn(htmf,'<P align='+HTMAlign2Str(align,'left')+'>');
  if italic in style then write(htmf,'<I>');
  if bold in style then write(htmf,'<B>');
  if underlined in style then write(htmf,'<U>');
  if sstrike in style then write(htmf,'<STRIKE>');
  if big in style then write(htmf,'<BIG>');
  if small in style then write(htmf,'<SMALL>');
  if sub in style then write(htmf,'<SUB>');
  if super in style then write(htmf,'<SUP>');
  write(htmf,'<A href="#'+name+'">'+HTMinternstring(title)+'</A>');
  if super in style then write(htmf,'</SUP>');
  if sub in style then write(htmf,'</SUB>');
  if small in style then write(htmf,'</SMALL>');
  if big in style then write(htmf,'</BIG>');
  if sstrike in style then write(htmf,'</STRIKE>');
  if underlined in style then write(htmf,'</U>');
  if bold in style then write(htmf,'</B>');
  if italic in style then write(htmf,'</I>');
end;

procedure HTMWriteLnLink(name,title:string;align:TJKAlign;style:tJKFontStyle);
begin
  WriteLn(htmf,'<P align='+HTMAlign2Str(align,'left')+'>');
  if italic in style then write(htmf,'<I>');
  if bold in style then write(htmf,'<B>');
  if underlined in style then write(htmf,'<U>');
  if sstrike in style then write(htmf,'<STRIKE>');
  if big in style then write(htmf,'<BIG>');
  if small in style then write(htmf,'<SMALL>');
  if sub in style then write(htmf,'<SUB>');
  if super in style then write(htmf,'<SUP>');
  writeLn(htmf,'<A href="#'+name+'">'+HTMinternstring(title)+'</A>');
  if super in style then write(htmf,'</SUP>');
  if sub in style then write(htmf,'</SUB>');
  if small in style then write(htmf,'</SMALL>');
  if big in style then write(htmf,'</BIG>');
  if sstrike in style then write(htmf,'</STRIKE>');
  if underlined in style then write(htmf,'</U>');
  if bold in style then write(htmf,'</B>');
  if italic in style then write(htmf,'</I>');
end;

procedure HTMOpenList(kind:tHTMListKind;compact:Boolean);
begin
  case kind of
    unordered: begin
                 Write(htmf,'<UL');
                 if compact then WriteLn(htmf,' compact>') else WriteLn(htmf,'>')
               end;
      ordered: begin
                 Write(htmf,'<OL');
                 if compact then WriteLn(htmf,' compact>') else WriteLn(htmf,'>')
               end;
    definition:begin
                 Write(htmf,'<DL');
                 if compact then WriteLn(htmf,' compact>') else WriteLn(htmf,'>')
               end;
  end;
end;

procedure HTMCloseList(kind:tHTMListKind);
begin
  case kind of
    unordered:  WriteLn(htmf,'</UL>');
      ordered:  WriteLn(htmf,'</OL>');
    definition: WriteLn(htmf,'</DL>');
  end;
end;

procedure HTMUListItem(text:string;Lstyle:tHTMUItemStyle);
begin
  case LStyle of
    disc:WriteLn(htmf,'  <LI type=disc>'+HTMinternstring(text));
    square:WriteLn(htmf,'  <LI type=square>'+HTMinternstring(text));
    circle:WriteLn(htmf,'  <LI type=circle>'+HTMinternstring(text));
  end;
end;

procedure HTMOListItem(text:string;Lstyle:tHTMOItemStyle);
begin
  case LStyle of
    arabic:WriteLn(htmf,'  <LI type=1>'+HTMinternstring(text));
    lowChar:WriteLn(htmf,'  <LI type=a>'+HTMinternstring(text));
    upChar:WriteLn(htmf,'  <LI type=A>'+HTMinternstring(text));
    lowRom:WriteLn(htmf,'  <LI type=i>'+HTMinternstring(text));
    upRom:WriteLn(htmf,'  <LI type=I>'+HTMinternstring(text));
  end;
end;

procedure HTMDefListItem(term,definition:string);
begin
  WriteLn(htmf,'  <DT>'+HTMinternstring(term)+' <DD>'+HTMinternstring(definition));
end;

procedure HTMImage(URL,PicReplace:string;border,left,top:LongInt);
begin
  writeLn(htmf,'<IMG src="'+URL+'" ALT="'+PicReplace+'" border='+inttostr(border)+' hspace='+inttostr(left)+' vspave='
    +inttostr(top)+'>');
end;

procedure HTMOpenTable(align:tJKAlign;width:LongInt;percent:Boolean;border,cellspacing,cellpadding:LongInt;caption:string;
                       capAlign:tHTMCapAlign);
begin
  write(htmf,'<TABLE align='+HTMAlign2Str(align,'left')+' width=');
  if percent then write(htmf,'"'+inttostr(width)+'%"') else write(htmf,inttostr(width));
  writeLn(htmf,' border='+inttostr(border)+' cellspacing='+inttostr(cellspacing)+' cellpadding='+inttostr(cellpadding)+'>');
  if caption<>'' then
    if capAlign=altop then WriteLn(htmf,'<CAPTION align=top>'+HTMinternstring(caption)+'</CAPTION>')
    else WriteLn(htmf,'<CAPTION align=bottom>'+HTMinternstring(caption)+'</CAPTION>');
end;

procedure HTMNewRow;
begin
  WriteLn(htmf);
  Write(htmf,'<tr>');
end;

procedure HTMNewCell;
begin
  WriteLn(htmf);
  Write(htmf,'<td>');
end;

procedure HTMNewHeaderCell;
begin
  WriteLn(htmf);
  Write(htmf,'<th>');
end;

procedure HTMCloseTable;
begin
  WriteLn(htmf,'</TABLE>');
end;

procedure HTMHeaderRow(items:TStrings);
var i:LongInt;
begin
  writeLn(htmf,'<TR>');
  for i:=0 to items.count-1 do begin
    writeLn(htmf,'  <TH>'+HTMinternstring(items.strings[i]));
  end;
  WriteLn(htmf,'');
end;

procedure HTMRow(items:TStrings);
var i:LongInt;
begin
  writeLn(htmf,'<TR>');
  for i:=0 to items.count-1 do begin
    writeLn(htmf,'  <TD>'+HTMinternstring(items.strings[i]));
  end;
  WriteLn(htmf,'');
end;

procedure HTMSpace(n:integer);
var i:integer;
begin
  for i:=1 to n do
    Write(htmf,'&nbsp;');
end;

function  HTMInternString(s:string):string;
var i:LongWord;
    s1:string;
begin
  result:='';
  for i:=1 to length(s) do begin
    s1:=s[i];
    if s[i]='' then s1:='&Auml;';
    if s[i]='' then s1:='&Ouml;';
    if s[i]='' then s1:='&Uuml;';
    if s[i]='' then s1:='&auml;';
    if s[i]='' then s1:='&ouml;';
    if s[i]='' then s1:='&uuml;';
    if s[i]='' then s1:='&szlig;';
    if s[i]='' then s1:='&eacute;';
    if s[i]='' then s1:='&egrave;';
    if s[i]='' then s1:='&ecirc;';
    if s[i]='' then s1:='&acirc;';
    if s[i]='' then s1:='&agrave;';
    if s[i]='' then s1:='&aacute;';
    if s[i]='' then s1:='&ucirc;';
    if s[i]='' then s1:='&uacute;';
    if s[i]='' then s1:='&ugrave;';
    if s[i]='' then s1:='&ocirc;';
    if s[i]='' then s1:='&Eacute;';
    if s[i]='' then s1:='&Egrave;';
    if s[i]='' then s1:='&Ecirc;';
    if s[i]='' then s1:='&Acirc;';
    if s[i]='' then s1:='&Agrave;';
    if s[i]='' then s1:='&Aacute;';
    if s[i]='' then s1:='&Ucirc;';
    if s[i]='' then s1:='&Uacute;';
    if s[i]='' then s1:='&Ugrave;';
    if s[i]='' then s1:='&Ocirc;';
    if s[i]='' then s1:='&sect;';
    if s[i]='' then s1:='&micro;';
    if s[i]='<' then s1:='&lt;';
    if s[i]='>' then s1:='&gt;';
    if s[i]='&' then s1:='&amp;';
    if s[i]='"' then s1:='&quot;';
    if s[i]='' then s1:='&iexcl;';
    if s[i]='' then s1:='&cent;';
    if s[i]='' then s1:='&pound;';
    if s[i]='' then s1:='&curren;';
    if s[i]='' then s1:='&yen;';
    if s[i]='' then s1:='&brvbar;';
    if s[i]='' then s1:='&uml;';
    if s[i]='' then s1:='&copy;';
    if s[i]='' then s1:='&ordf;';
    if s[i]='' then s1:='&laquo;';
    if s[i]='' then s1:='&not;';
    if s[i]='' then s1:='&shy;';
    if s[i]='' then s1:='&reg;';
    if s[i]='' then s1:='&macr;';
    if s[i]='' then s1:='&deg;';
    if s[i]='' then s1:='&plusmn;';
    if s[i]='' then s1:='&sup2;';
    if s[i]='' then s1:='&sup3;';
    if s[i]='' then s1:='&acute;';
    if s[i]='' then s1:='&para;';
    if s[i]='' then s1:='&middot;';
    if s[i]='' then s1:='&cedil;';
    if s[i]='' then s1:='&sup1;';
    if s[i]='' then s1:='&ordm;';
    if s[i]='' then s1:='&raquo;';
    if s[i]='' then s1:='&frac14;';
    if s[i]='' then s1:='&frac12;';
    if s[i]='' then s1:='&frac34;';
    if s[i]='' then s1:='&iquest;';
    if s[i]='' then s1:='&Atilde;';
    if s[i]='' then s1:='&Auml;';
    if s[i]='' then s1:='&Aring;';
    if s[i]='' then s1:='&AElig;';
    if s[i]='' then s1:='&Ccedil;';
    if s[i]='' then s1:='&Euml;';
    if s[i]='' then s1:='&Igrave;';
    if s[i]='' then s1:='&Iacute;';
    if s[i]='' then s1:='&Icirc;';
    if s[i]='' then s1:='&Iuml;';
    if s[i]='' then s1:='&ETH;';
    if s[i]='' then s1:='&Ntilde;';
    if s[i]='' then s1:='&Ograve;';
    if s[i]='' then s1:='&Oacute;';
    if s[i]='' then s1:='&Otilde;';
    if s[i]='' then s1:='&times;';
    if s[i]='' then s1:='&Oslash;';
    if s[i]='' then s1:='&Yacute;';
    if s[i]='' then s1:='&THORN;';
    if s[i]='' then s1:='&atilde;';
    if s[i]='' then s1:='&aring;';
    if s[i]='' then s1:='&aelig;';
    if s[i]='' then s1:='&ccedil;';
    if s[i]='' then s1:='&euml;';
    if s[i]='' then s1:='&igrave;';
    if s[i]='' then s1:='&iacute;';
    if s[i]='' then s1:='&icirc;';
    if s[i]='' then s1:='&iuml;';
    if s[i]='' then s1:='&eth;';
    if s[i]='' then s1:='&ntilde;';
    if s[i]='' then s1:='&ograve;';
    if s[i]='' then s1:='&oacute;';
    if s[i]='' then s1:='&otilde;';
    if s[i]='' then s1:='&divide;';
    if s[i]='' then s1:='&oslash;';
    if s[i]='' then s1:='&yacute;';
    if s[i]='' then s1:='&thorn;';
    if s[i]='' then s1:='&yuml;';

    result:=result+s1;
  end;
end;


end.
