unit JKChem;

interface

{-------------------------------------------------------------------------------
Author:      Jan Krieger, Ismaning (Munich), Germany
             jan@jkrieger.de
             http://www.jkrieger.de/
Date:        November 30. 2000
Name:        unit JKChem  with TJKChemLabel
Version:     1.1
Copyright:   (c) 2000 by Jan W. Krieger. All rights reserved.
Description: These two procedures can draw a chemical formula (such as C6H12O6)
             onto a canvas. When doing this it writes indexes lowered and adds
             more formatting to it.                                                 |    3+  |
             If you want to draw an Ion, then Write for example  'SO4 3+'  to get:  | SO     |
             This means that you can add a load to an atom by adding (a number      |   4    |
             and) a + or -. This +/- and the number will be drawn superscript.
             If you want to add an reaction-+ after a non-ion then insert two
             whitespaces before!                    |           |
                                   'Ce3+ + Ce'  ==> |Ce   +  Ce |
                                        ~           |  3+       |

                                                    |  3+      |
                                   'Ce3+  + Ce' ==> |Ce   + Ce |
                                        ~~
             alpha, beta, gamma, delta, pi epsilon ... are replaced by their
             corresponding greek letters (font: Symbol !!!). To achieve big greek
             letters you should write the name's first letter in uppercase: Alpha, Beta ...
             Some spcial symbols are defined: arrows: -> --> ---> <-> => <=>
                                              math:   +- inf prop |= sum  

             canvas: the TCanvas to draw on
             left top, width, height: the coordinates to draw into
             fontname, fontsize: the Font to use
             bkColor: the backgroundcolor to use
             express: the formula to draw
             insert: distance between two element-symbols (in pixels)

             TJKChemLabel encapsulates the functionality of the procedures
             into one component.
             
Status:      This Unit is FREEWARE, so no support can be granted
             Everybody may feel free to copy and use it.
             If you alter the sourcecode, it would be kind to send me the
             new source!

--------------------------------------------------------------------------------
                   This comment may not be deleted !!!
--------------------------------------------------------------------------------}

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  DB,
  DBCtrls,
  extctrls;

type
  TJKChemLabel = class(TCustomControl)
  private
    { Private-Deklarationen}
    FLD:longint;
    FColor:TColor;
    FChemFont:TFont;
    FText:string;
    procedure DataChange(Sender:TObject);
    procedure SetColor(value:TColor);
    procedure SetText(value: string);
  protected
    { Protected-Deklarationen}
    procedure Change(Sender:TObject);
  public
    { Public-Deklarationen}
    constructor Create(AOwner:TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  published
    { Published-Deklarationen }
    property LetterDistance:longint read FLD write FLD;
    property ChemFont:TFont read FChemFont write FChemFont;
    property Color read FColor write SetColor;
    property Formula:string read FText write SetText;
  end;

procedure Register;

procedure WriteChemExpressold(canvas:TCanvas;left,top,width,height:longint;fontname:string;fontsize:longint;bkColor:TColor;insert:longint;express:string);
procedure WriteChemExpress(canvas:TCanvas;left,top,width,height:longint;fontname:string;fontsize:longint;bkColor:TColor;insert:longint;express:string);

implementation

procedure Register;
begin
  RegisterComponents('JKSoft', [TJKChemLabel]);
end;

procedure WriteChemExpress(canvas:TCanvas;left,top,width,height:longint;fontname:string;fontsize:longint;bkColor:TColor;insert:longint;express:string);
var s,txt:string;
    i,l,t,fs, ltop, last, textflag:longint;
    r:TRect;
begin
  s:=express;
  fs:=fontsize;
  canvas.font.name:=fontname;
  canvas.font.size:=fs;
  r.top:=0;
  r.left:=0;
  r.right:=width;
  r.bottom:=height;
  Canvas.brush.color:=bkColor;
  Canvas.brush.style:=bsSolid;
  Canvas.FillRect(r);
  textflag:=canvas.textflags;
  canvas.TextFlags := ETO_CLIPPED;
  l:=left; t:=top;
  top:=top+round(canvas.textheight('quator')/5);
  ltop:=top;
  last:=fs;
  canvas.font.name:=fontname;
  if length(s)=0 then exit;
  i:=1;
  repeat
    with canvas do begin
      font.size:=last;
      font.style:=[];

      t:=ltop;
      txt:=s[i];

      if i>1 then begin
        if (s[i-1]in ['a'..'z','A'..'Z',')',']','}'])and(s[i] in ['0'..'9'])and(last=fs) then begin
          t:=top+round(textheight(s[i])/3)*2;
          font.size:=round(fs /3)* 2;
        end;
        if (s[i]in['A'..'Z','*','[','(','{','}',']',')','*',' ','|', '\', '/', '>', '<']) then begin
            t:=top;
            font.size:=fs;
        end;
      end;

      if (i>1) then if(i<length(s)-1)and(s[i-1]in['0'..'9', 'a'..'z', 'A'..'Z','}',']',')','|']) then begin
        if (s[i+1]in['+', '-', '.', ''])and(s[i]in[' ']) then begin
          txt:=s[i+1]; i:=i+1;
          t:=top-round(textheight(txt)/5);
          font.size:=round(fs /3)* 2;
        end;
        if i<length(s)-2 then
          if (s[i+2]in['+', '-', '.', ''])and(s[i]in[' '])and(s[i+1]in['0'..'9']) then begin
            txt:=s[i+1]+s[i+2]; i:=i+2;
            t:=top-round(textheight(txt)/5);
            font.size:=round(fs /3)* 2;
          end;
      end;

      if i<length(s) then begin
        if(s[i]='<')and(not(s[i+1]in['-', '='])) then begin txt:=''; font.name:='Symbol'; end;
        if s[i]+s[i+1]='+-' then begin txt:=''; i:=i+1; end;
      end;
      if s[i]='*' then begin txt:='  ' end
      else if (s[i]='<')and(i=length(s)) then begin txt:=''; font.name:='Symbol'; end
      else if s[i]='>' then begin txt:=''; font.name:='Symbol'; end

      else if pos('->',s)=i then begin txt:=' '; i:=i+1; font.name:='Symbol'; end
      else if pos('=>',s)=i then begin txt:='  '; i:=i+1; font.name:='Symbol'; end
      else if pos('-->',s)=i then begin txt:='  '; i:=i+2; font.name:='Symbol'; end
      else if pos('--->',s)=i then begin txt:='   '; i:=i+3; font.name:='Symbol'; end
      else if pos('<->',s)=i then begin txt:='  '; i:=i+2; font.name:='Symbol'; end
      else if pos('<=>',s)=i then begin txt:='  '; i:=i+2; font.name:='Symbol'; end
      else if pos('inf',s)=i then begin txt:=' '; i:=i+2; font.name:='Symbol'; end
      else if pos('prop',s)=i then begin txt:=''; i:=i+3; font.name:='Symbol'; end
      else if pos('|=',s)=i then begin txt:=' '; i:=i+1; font.name:='Symbol'; end
      else if pos('sum',s)=i then begin txt:=''; i:=i+2; font.name:='Symbol'; end


      else if pos('beta',s)=i then begin txt:='b'; i:=i+3; font.name:='Symbol'; end
      else if pos('psi',s)=i then begin txt:='y'; i:=i+2; font.name:='Symbol'; end
      else if pos('alpha',s)=i then begin txt:='a'; i:=i+4; font.name:='Symbol'; end
      else if pos('gamma',s)=i then begin txt:='g'; i:=i+4; font.name:='Symbol'; end
      else if pos('delta',s)=i then begin txt:='d'; i:=i+4; font.name:='Symbol'; end
      else if pos('pi',s)=i then begin txt:='p'; i:=i+1; font.name:='Symbol'; end
      else if pos('zeta',s)=i then begin txt:='z '; i:=i+3; font.name:='Symbol'; end
      else if pos('theta',s)=i then begin txt:='J'; i:=i+4; font.name:='Symbol'; end
      else if pos('jota',s)=i then begin txt:='i '; i:=i+3; font.name:='Symbol'; end
      else if pos('kappa',s)=i then begin txt:='k'; i:=i+4; font.name:='Symbol'; end
      else if pos('lambda',s)=i then begin txt:='l '; i:=i+5; font.name:='Symbol'; end
      else if pos('mu',s)=i then begin txt:='m'; i:=i+1; font.name:='Symbol'; end
      else if pos('nu',s)=i then begin txt:='n'; i:=i+1; font.name:='Symbol'; end
      else if pos('xi',s)=i then begin txt:='x '; i:=i+1; font.name:='Symbol'; end
      else if pos('omikron',s)=i then begin txt:='o'; i:=i+6; font.name:='Symbol'; end
      else if pos('rho',s)=i then begin txt:='r '; i:=i+2; font.name:='Symbol'; end
      else if pos('sigma',s)=i then begin txt:='s '; i:=i+4; font.name:='Symbol'; end
      else if pos('tau',s)=i then begin txt:='t'; i:=i+2; font.name:='Symbol'; end
      else if pos('ypsilon',s)=i then begin txt:='u'; i:=i+6; font.name:='Symbol'; end
      else if pos('epsilon',s)=i then begin txt:='e'; i:=i+6; font.name:='Symbol'; end
      else if pos('phi',s)=i then begin txt:='j  '; i:=i+2; font.name:='Symbol'; end
      else if pos('chi',s)=i then begin txt:='c'; i:=i+2; font.name:='Symbol'; end
      else if pos('eta',s)=i then begin txt:='e'; i:=i+2; font.name:='Symbol'; end
      else if pos('omega',s)=i then begin txt:='w'; i:=i+4; font.name:='Symbol'; end

      else if pos('Eta',s)=i then begin txt:='H'; i:=i+2; font.name:='Symbol'; end
      else if pos('Psi',s)=i then begin txt:='Y '; i:=i+2; font.name:='Symbol'; end
      else if pos('Zeta',s)=i then begin txt:='Z'; i:=i+3; font.name:='Symbol'; end
      else if pos('Theta',s)=i then begin txt:='Q'; i:=i+4; font.name:='Symbol'; end
      else if pos('Jota',s)=i then begin txt:='I '; i:=i+3; font.name:='Symbol'; end
      else if pos('Kappa',s)=i then begin txt:='K'; i:=i+4; font.name:='Symbol'; end
      else if pos('Lambda',s)=i then begin txt:='L'; i:=i+5; font.name:='Symbol'; end
      else if pos('Mu',s)=i then begin txt:='M'; i:=i+1; font.name:='Symbol'; end
      else if pos('Nu',s)=i then begin txt:='N'; i:=i+1; font.name:='Symbol'; end
      else if pos('Xi',s)=i then begin txt:='X'; i:=i+1; font.name:='Symbol'; end
      else if pos('Omikron',s)=i then begin txt:='O'; i:=i+6; font.name:='Symbol'; end
      else if pos('Rho',s)=i then begin txt:='R'; i:=i+2; font.name:='Symbol'; end
      else if pos('Sigma',s)=i then begin txt:='S'; i:=i+4; font.name:='Symbol'; end
      else if pos('Tau',s)=i then begin txt:='T '; i:=i+2; font.name:='Symbol'; end
      else if pos('Epsilon',s)=i then begin txt:='E'; i:=i+6; font.name:='Symbol'; end
      else if pos('Ypsilon',s)=i then begin txt:='U'; i:=i+6; font.name:='Symbol'; end
      else if pos('Phi',s)=i then begin txt:='F '; i:=i+2; font.name:='Symbol'; end
      else if pos('Chi',s)=i then begin txt:='C'; i:=i+2; font.name:='Symbol'; end
      else if pos('Omega',s)=i then begin txt:='W'; i:=i+4; font.name:='Symbol'; end
      else if pos('Alpha',s)=i then begin txt:='A'; i:=i+4; font.name:='Symbol'; end
      else if pos('Beta',s)=i then begin txt:='B'; i:=i+3; font.name:='Symbol'; end
      else if pos('Gamma',s)=i then begin txt:='G'; i:=i+4; font.name:='Symbol'; end
      else if pos('Delta',s)=i then begin txt:='D'; i:=i+4; font.name:='Symbol'; end
      else if pos('Pi',s)=i then begin txt:='P'; i:=i+1; font.name:='Symbol'; end;


      textout(l,t,txt);
      last:=font.Size;
      font.name:=fontname;
      ltop:=t;
      l:=l+textwidth(txt);
      if (i<length(s))and(s[i] in ['a'..'z', '0'..'9', 'A'..'Z']) then
        if s[i+1] in ['A'..'Z','[',']','(',')','{','}','*','|','<','>'] then l:=l+insert;
      if (i<length(s))and(s[i] in ['[',']','(',')','{','}','*','|','<','>']) then
        if s[i+1] in ['A'..'Z','a'..'z','0'..'9'] then l:=l+insert;
    end;
    inc(i);
  until i>length(s);
  canvas.textflags:=textflag;
end;

procedure WriteChemExpressold(canvas:TCanvas;left,top,width,height:longint;fontname:string;fontsize:longint;bkColor:TColor;insert:longint;express:string);
var s,txt:string;
    i,l,t,fs, ltop:longint;
    r:TRect;
    norm:boolean;
begin
  s:=express;
  fs:=fontsize;
  canvas.font.name:=fontname;
  canvas.font.size:=fs;
  r.top:=0;
  r.left:=0;
  r.right:=width;
  r.bottom:=height;
  Canvas.brush.color:=bkColor;
  Canvas.brush.style:=bsSolid;
  Canvas.FillRect(r);
  l:=left; t:=top;
  norm:=true;
  ltop:=top;
  FOR i:=1 to length(s) do begin
    with canvas do begin
      font.name:=fontname;
      font.size:=fs;
      font.style:=[];

      t:=top;
      txt:=s[i];
      if s[i] in ['0'..'9','-'] then begin
        if i<>1 then begin
          t:=top+round(textheight(s[i])/3)*2;
          font.size:=round(fs /3)* 2;
        end;
        if i>1 then
          if (s[i-1] in ['[','(','{','*',' ','|','>', '\', '/','-', ','])or((s[i-1]in['0'..'9'])and norm) then begin
            t:=top;
            font.size:=fs;
            norm:=true;
          end else norm:=false;
      end else norm:=true;
      if s[i]='*' then txt:='  ';
      textout(l,t,txt);
      ltop:=t;
      l:=l+textwidth(txt);
      if (i<length(s))and(s[i] in ['a'..'z', '0'..'9', 'A'..'Z']) then
        if s[i+1] in ['A'..'Z','[',']','(',')','{','}','*','|','<','>'] then l:=l+insert;
      if (i<length(s))and(s[i] in ['[',']','(',')','{','}','*','|','<','>']) then
        if s[i+1] in ['A'..'Z','a'..'z','0'..'9'] then l:=l+insert;
    end;
  end;
end;



{TJKChemLabel.}
constructor TJKChemLabel.Create(AOwner:TComponent);
begin
  inherited Create (AOwner);
  FChemFont:=TFont.Create;
  Font.OnChange:=Change;
  width := 200;
  height := 22;
  LetterDistance:=2;
  color:=clWindow;
  FChemFont.name:='Arial';
  FChemFont.Size:=12;
  //DataChange(self);
end;

destructor TJKChemLabel.Destroy;
begin
  FChemFont.Destroy;
  inherited destroy;
end;

procedure TJKChemLabel.SetColor(value:TColor);
begin
  FColor:=value;
  DataChange(self);
end;

procedure TJKChemLabel.Paint;
begin
  DataChange(self);
end;

procedure TJKChemLabel.DataChange(Sender:TObject);
var r:TRect;
begin
  if Ftext<>'' then begin
      canvas.Brush.color:=FColor;
      r.top:=0;
      r.left:=0;
      r.right:=width;
      r.bottom:=height;
      Canvas.FillRect(r);
      canvas.Font.assign(FChemFont);
      WriteChemExpress(canvas,1,1,width,height,FChemFont.name,FChemFont.size,FColor,FLD,FText);
  end else
  if (csDesigning in ComponentState) then FText:=Name
                                  else FText:='';
end;

procedure TJKChemLabel.Change(Sender:TObject);
begin
  DataChange(self);
end;

procedure TJKChemLabel.SetText(value: string);
begin
  FText:=value;
  DataChange(self);
end;

end.
