unit JKDBChem;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  DB,
  DBCtrls,
  JKChem,
  extctrls,
  FrmlEditFrm;

type
  TJKDBChem = class(TCustomControl)
  private
    { Private-Deklarationen}
    FDataLink:TFieldDataLink;
    FLD:longint;
    FColor:TColor;
    FChemFont:TFont;
    procedure DataChange(Sender:TObject);
    procedure EditingChange(Sender:TObject);
    procedure UpdateData(Sender:TObject);
    function GetdataField:string;
    function GetDataSource:TDataSource;
    procedure SetDataField(const value:string);
    procedure SetDataSource(value:TDataSource);
    procedure SetColor(value:TColor);
    procedure CMGetDataLink(var message:TMessage); message CM_GETDATALINK;
  protected
    { Protected-Deklarationen}
    procedure DblClick;override;
    procedure Change(Sender:TObject);
    procedure Notification(AComponent:TComponent; Operation:TOperation); override;
  public
    { Public-Deklarationen}
    constructor Create(AOwner:TComponent); override;
    destructor Destroy; override;
    procedure StartEditor;    // --> startet den Formeleditor
    procedure Paint; override;
  published
    { Published-Deklarationen }
    property DataField: string read GetDataField write SetDataField;
    property DataSource:TDataSource read getDataSource write SetDataSource;
    property LetterDistance:longint read FLD write FLD;
    property ChemFont:TFont read FChemFont write FChemFont;
    property Color read FColor write SetColor;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('JKSoft', [TJKDBChem]);
end;

{TJKDBChem.}
constructor TJKDBChem.Create(AOwner:TComponent);
begin
  inherited Create (AOwner);
  FChemFont:=TFont.Create;
  FDataLink:=TFieldDataLink.Create;
  with FDataLink do begin
    Control:=self;
    OnDataChange:=DataChange;
    OnEditingChange:=EditingChange;
    OnUpdatedata:=UpdateData;
  end;
  Font.OnChange:=Change;
  width := 200;
  height := 22;
  LetterDistance:=2;
  color:=clWindow;
  FChemFont.name:='Arial';
  FChemFont.Size:=12;
  //DataChange(self);
end;

destructor TJKDBChem.Destroy;
begin
  FDataLink.free;
  FDataLink:=nil;
  FChemFont.Destroy;
  inherited destroy;
end;

procedure TJKDBChem.SetColor(value:TColor);
begin
  FColor:=value;
  DataChange(self);
end;

procedure TJKDBChem.Paint;
begin
  DataChange(self);
end;

procedure TJKDBChem.DataChange(Sender:TObject);
var r:TRect;
begin
  if FDataLink.Field<>nil then begin
    if FDataLink.Field is TStringField then
      Text:=FDataLink.Field.Asstring;
    //Modified:=false;
      canvas.Brush.color:=FColor;
      r.top:=0;
      r.left:=0;
      r.right:=width;
      r.bottom:=height;
      Canvas.FillRect(r);
      canvas.Font.assign(FChemFont);
      if not fDataLink.DataSource.dataset.controlsdisabled then WriteChemExpress(canvas,1,1,width,height,FChemFont.name,FChemFont.size,FColor,FLD,Text);
  end else
  if csDesigning in ComponentState then Text:=Name
                                  else Text:='';
end;

procedure TJKDBChem.EditingChange(Sender:TObject);
begin
  inherited;
  DataChange(self);
end;

procedure TJKDBChem.UpdateData(Sender:TObject);
begin
  FDataLink.Field.Asstring:=Text;
  DataChange(self);
end;

function TJKDBChem.GetdataField:string;
begin result:=FdataLink.Fieldname;  end;

function TJKDBChem.GetDataSource:TDataSource;
begin Result:=FDataLink.DataSource end;

procedure TJKDBChem.SetDataField(const value:string);
begin
  FDataLink.FieldName:=value;
  DataChange(self);
end;

procedure TJKDBChem.SetDataSource(value:TDataSource);
begin
  FDataLink.DataSource:=value;
  if value<>nil then value.FreeNotification(self);
end;

procedure TJKDBChem.CMGetDataLink(var message:TMessage);
begin
  Message.Result := Integer(FDataLink);
end;

procedure TJKDBChem.DblClick;
begin
  inherited DblClick;
  StartEditor;
end;

procedure TJKDBChem.StartEditor;
begin
  JKCFormelEdit:=TJKCFormelEdit.create(self);
  JKCFormelEdit.edit1.text:=Text;
  JKCFormelEdit.LetterDis:=FLD;
  JKCFormelEdit.Image1.canvas.font.assign(FChemFont);
  if JKCFormelEdit.showmodal=mrOK then begin
    FDataLink.Edit;
    Text:=JKCFormelEdit.edit1.text;
    FDataLink.Modified;
  end;
  JKCFormelEdit.free;
  DataChange(self);
end;

procedure TJKDBChem.Change(Sender:TObject);
begin
  DataChange(self);
end;

procedure TJKDBChem.Notification(AComponent:TComponent; Operation:TOperation);
begin
  inherited Notification(Acomponent, Operation);
  if (Operation=opRemove) and (FDatalink<>nil) and (AComponent=DataSource) then DataSource:=nil;
end;

end.
