{ unit jkLATEX ver 1.0
(c) 2000 by Jan W. Krieger
jan@jkrieger.de
www.jkrieger.de

Diese unit erzeugt eine LaTeX-Datei

  tJKAlign=(alleft, alcenter, alright, aldef, alblock, alNone);
  tJKEFontStyle=  set of (jfsItalic,jfsBold,jfsSub,jfsSuper,jfsUnderlined,jfsDoubleUL);

}
unit jklatex;

interface

uses classes, sysutils, JKEStructs;

const LATEXICFormatCount=3;
      LATEXICFormat:ARRAY[0..LATEXICFormatCount-1, 1..2] of string=(
        (' TeX','\TeX'),
        (' LaTeX','\LaTeX'),
        (#13#10,'\\'));

const LATEXFormatCount=98;
      LATEXFormat:ARRAY[0..LATEXFormatCount-1, 1..2] of string=(
        ('\','\begin{math}\backslash\end{math}""'),
        ('/','/""'),
        ('~','{/~}'),
        ('$','\$ '),
        ('"','{\dq}'),
        ('{','\{ '),
        ('}','\} '),
        ('&','{\&}'),
        ('%','{\%}'),
        ('#','{\#}'),
        ('_','{\_}'),
        ('','{\S}'),
        ('','{\pounds}'),
        ('<','$<$'),
        ('>','$>$'),
        ('','?`'),
        ('','!`'),
        ('','{\ae}'),
        ('','{\AE}'),
        ('','{\aa}'),
        ('','{\AA}'),
        ('','{\o}'),
        ('','{\O}'),
        ('','{\ss}'),
        ('','\"{a}'),
        ('','\"{o}'),
        ('','\"{u}'),
        ('','\"{A}'),
        ('','\"{O}'),
        ('','\"{U}'),
        ('','\c{c}'),
        ('','\c{C}'),
        ('','\`{a}'),
        ('','\`{A}'),
        ('','\''{a}'),
        ('','\''{A}'),
        ('','\^{a}'),
        ('','\^{A}'),
        ('','\~{a}'),
        ('','\~{A}'),
        ('','\`{e}'),
        ('','\`{E}'),
        ('','\''{e}'),
        ('','\''{E}'),
        ('','\^{e}'),
        ('','\^{E}'),
        ('','\"{e}'),
        ('','\"{E}'),
        ('','\`{i}'),
        ('','\`{I}'),
        ('','\''{i}'),
        ('','\''{I}'),
        ('','\^{i}'),
        ('','\^{I}'),
        ('','\"{i}'),
        ('','\"{I}'),
        ('','\~{n}'),
        ('','\~{N}'),
        ('','\`{o}'),
        ('','\`{O}'),
        ('','\''{o}'),
        ('','\''{O}'),
        ('','\^{o}'),
        ('','\^{O}'),
        ('','\~{o}'),
        ('','\~{O}'),
        ('','\`{u}'),
        ('','\`{U}'),
        ('','\''{u}'),
        ('','\''{U}'),
        ('','\^{u}'),
        ('','\^{U}'),
        ('','\''{y}'),
        ('','\''{Y}'),
        ('','\"{y}'),
        ('','{\times}'),
        ('','{\div}'),
        ('','{\pm}'),
        ('','{\copyright}'),
        ('','{\neg}'),
        ('','{\cdot}'),
        ('','{\P}'),
        ('|','$\mid$'),
        ('','\ldots'),
        ('','$\mu$'),
        ('','{\flqq}'),
        ('','{\frqq}'),
        ('','{\glq}'),
        ('','{\grq}'),
        ('','{\glqq}'),
        ('','{\grqq}'),
        ('','{\glqq}'),
        ('','{\OE}'),
        ('','\v{S}'),
        ('','\v{Z}'),
        ('','\v{s}'),
        ('','\v{z}'),
        ('','--'));
const LATEXReFormatCount=144;
      LATEXReFormat:ARRAY[0..LATEXReFormatCount-1, 1..2] of string=(
        ('LaTeX','\LaTeX'), ('TeX','\TeX'),
        ('&','\&'), ('%','\%'), ('#','\#'), ('_','\_'), ('','\S'), ('','\pounds'),
        ('<','$<$'), ('>','$>$'),  ('','?`'),  ('','!`'),
        ('','\ae'), ('','\AE'), ('','\aa'), ('','\AA'), ('','\o'), ('','\O'),
        ('','\ss'), ('','\"{a}'), ('','\"{o}'), ('','\"{u}'),('','\"{A}'), ('','\"{O}'),
        ('','\"{U}'), ('','\"a'),  ('','\"o'), ('','\"u'), ('','\"A'), ('','\"O'),
        ('','\"U'), ('','\c{c}'), ('','\c{C}'), ('','\`{a}'), ('','\`{A}'), ('','\''{a}'),
        ('','\''{A}'), ('','\^{a}'), ('','\^{A}'), ('','\~{a}'), ('','\~{A}'), ('','\`{e}'),
        ('','\`{E}'), ('','\''{e}'), ('','\''{E}'), ('','\^{e}'), ('','\^{E}'), ('','\`a'),
        ('','\`A'), ('','\''a'), ('','\''A'), ('','\^a'), ('','\^A'), ('','\~a'), ('','\~A'),
        ('','\`e'), ('','\`E'), ('','\''e'), ('','\''E'), ('','\^e'), ('','\^E'), ('','\"{e}'),
        ('','\"{E}'), ('','\"e'), ('','\"E'), ('','\`{i}'), ('','\`{I}'), ('','\''{i}'),
        ('','\''{I}'), ('','\^{i}'),  ('','\^{I}'), ('','\"{i}'), ('','\"{I}'), ('','\"i'),
        ('','\"I'), ('','\~{n}'), ('','\~{N}'), ('','\~n'), ('','\~N'), ('','\`{o}'),
        ('','\`{O}'), ('','\''{o}'),('','\''{O}'), ('','\^{o}'), ('','\^{O}'), ('','\~{o}'),
        ('','\~{O}'), ('','\`{u}'), ('','\`{U}'), ('','\''{u}'), ('','\''{U}'), ('','\^{u}'),
        ('','\^{U}'), ('','\''{y}'), ('','\''{Y}'), ('','\`o'), ('','\`O'), ('','\''o'),
        ('','\''O'),  ('','\^o'), ('','\^O'), ('','\~o'),  ('','\~O'),  ('','\`u'),
        ('','\`U'), ('','\''u'), ('','\''U'), ('','\^u'), ('','\^U'), ('','\''y'),
        ('','\''Y'),('','\"{y}'), ('','\"y'), ('','\times'), ('','\div'), ('','\pm'),
        ('','\copyright'), ('','\neg'), ('','\cdot'), ('','\P'), ('|','$\mid$'),
        ('','\ldots'), ('','$\mu$'), ('','\flqq'), ('','\frqq'),  ('','\glq'), ('','\grq'),
        ('','\glqq'), ('','\grqq'), ('','\glqq'), ('','\OE'), ('','\v{S}'), ('','\v{Z}'),
        ('','\v{s}'), ('','\v{z}'), ('-','---'), ('','--'), ('','"a'), ('','"o'), ('','"u'),
        ('','"A'), ('','"O'), ('','"U'), ('','"s'));

type tLatexfile=record
       f:system.text;
       style:tJKFontStyle;
       align:tJKAlign;
       size:longint;
       filename:string;
     end;
     tLatexPageStyles=(lpsPlain, lpsEmpty, lpsHeadings, lpsMyHeadings, lpsNone);

procedure LATEXOpen(var f:tLatexFile; filename:string; documentclass, documentoptions:string; pagestyle:tLatexPageStyles);
{ erzeugt eine neue LaTeX-Datei mit dem Namen
     <f>                   Datei-Variable
     <filename>            Dateiname
     <documentclass>       Dokumentenklasse
     <documentoptions>     Dokumentenoptionen (durch ',' getrennt)
     <pagestyle>           Option fr Pagestyle-Befehl
     <usepackages>         benutzte Packages (durch ',' getrennt)
}
procedure LATEXClose(var f: tLatexFile);
{ schliet eine geffnete LATEX-Datei wieder
}
procedure LATEXWrite(var f: tLatexFile; text: string);
procedure LATEXWriteRaw(var f: tLatexFile; text: string);
procedure LATEXWriteLn(var f: tLatexFile; text: string);
procedure LATEXLineBreak(var f: tLatexFile);
procedure LATEXParagraphBreak(var f: tLatexFile);
procedure LATEXSetAlign(var f:tLatexFile; align:tJKAlign);
procedure LATEXWriteTab(var f: tLatexfile);
procedure LATEXSetFontStyle(var f: tLatexFile; style: tJKFontStyle; size: Integer);
function LATEXformatText(text:string):string;
procedure LATEXRemoveAllStyles(var f: tLatexFile);
procedure LATEXStartTheBibliography(var f: tLatexFile; muster_marke: string);
procedure LATEXStopTheBibliography(var f: tLatexFile);
procedure LATEXWriteBibItem(var f: tLatexFile; mark, id:string);
//function LATEXExtractText(latex: string): string;
function LATEXCleanUp(latex:string):string;

implementation

function LATEXformatText(text:string):string;
var i, j:longint;
    res:string;
begin
  result:='';
  {for i:=0 to LATEXFormatCount-1 do
    result:=stringreplace(result, LATEXFormat[i, 1], LATEXFormat[i, 2], [rfReplaceAll]);}
  for i:=1 to length(text) do begin
    j:=-1;
    res:=text[i];
    repeat
      inc(j);
      if text[i]=LATEXFormat[j, 1] then res:=LATEXFormat[j, 2];
    until (text[i]=LATEXFormat[j, 1])or(j=LATEXFormatCount-1);
    result:=result+res;
  end;
  for i:=0 to LATEXICFormatCount-1 do
    result:=stringreplace(result, LATEXICFormat[i, 1], LATEXICFormat[i, 2], [rfReplaceAll]);
end;

procedure LATEXOpen(var f:tLatexFile; filename:string; documentclass, documentoptions:string; pagestyle:tLatexPageStyles);
begin
  f.filename:=filename;
  f.style:=[];
  f.align:=alBlock;
  f.size:=12;
  assignfile(f.f, filename+'.tmp');
  rewrite(f.f);
  writeLn(f.f, '\documentclass['+documentoptions+']{'+documentclass+'}');
  case pagestyle of
    lpsPlain: WriteLn(f.f, '\pagestyle{plain}');
    lpsEmpty: WriteLn(f.f, '\pagestyle{empty}');
    lpsHeadings: WriteLn(f.f, '\pagestyle{headings}');
    lpsMyHeadings: WriteLn(f.f, '\pagestyle{myheadings}');
  end;
  writeln(f.f, '\begin{document}');
end;

procedure LATEXClose(var f: tLatexFile);
var s:string;
    f1:system.text;
begin
  writeln(f.f, '\end{document}');
  closefile(f.f);
  assignfile(f.f, f.filename+'.tmp');
  reset(f.f);
  assignfile(f1, f.filename);
  rewrite(f1);

  //Optimierung des Dokumentes
  while not eof(f.f) do begin
    ReadLn(f.f, s);
    WriteLn(f1, latexCleanUp(s));
  end;
  CloseFile(f1);
  CloseFile(f.f);
  Deletefile(f.filename+'.tmp');
end;

procedure LATEXWrite(var f: tLatexFile; text: string);
begin
  if (sub in f.style)or (super in f.style) then begin
    text:=stringreplace(text, #13, '', [rfReplaceAll, rfIgnoreCase]);
    text:=stringreplace(text, #10, '', [rfReplaceAll, rfIgnoreCase]);
  end;
  write(f.f, LATEXformatText(text));
end;

procedure LATEXWriteRaw(var f: tLatexFile; text: string);
begin
  write(f.f, text);
end;

procedure LATEXWriteLn(var f: tLatexFile; text: string);
begin
  if (sub in f.style)or (super in f.style) then begin
    text:=stringreplace(text, #13, '', [rfReplaceAll, rfIgnoreCase]);
    text:=stringreplace(text, #10, '', [rfReplaceAll, rfIgnoreCase]);
  end;
  LATEXWrite(f, text);
  if (not (sub in f.style))and(not(super in f.style)) then LATEXLineBreak(f);
end;

procedure LATEXLineBreak(var f: tLatexFile);
begin
  if (not (sub in f.style))and(not(super in f.style)) then WriteLn(f.f, '\\');
end;

procedure LATEXParagraphBreak(var f: tLatexFile);
begin
  WriteLn(f.f,'');
  Write(f.f, '\par ');
end;

procedure LATEXSetAlign(var f:tLatexFile; align:tJKAlign);
begin
  if (f.align = alleft) then writeln(f.f, #13#10'\end{flushleft}');
  if (f.align = alcenter) then writeln(f.f, #13#10'\end{center}');
  if (f.align = alright) then writeln(f.f, #13#10'\end{flushright}');
  f.align:=align;
  if (f.align = alleft) then writeln(f.f, #13#10'\begin{flushleft}');
  if (f.align = alcenter) then writeln(f.f, #13#10'\begin{center}');
  if (f.align = alright) then writeln(f.f, #13#10'\begin{flushright}');
end;

procedure LATEXWriteTab(var f: tLatexfile);
begin
  write(f.f, '{\hspace{10mm}}');
end;

procedure LATEXSetFontStyle(var f: tLatexFile; style: tJKFontStyle;   size: Integer);
begin
  LATEXRemoveAllStyles(f);
  if (super in style) and (sub in style) then style:=style-[sub];
  if super in style then write(f.f,'$^{');
  if sub in style then write(f.f,'$_{');
  if big in style then write(f.f,'{\sc ');
  if underlined in style then write(f.f,'\underline{');
  if italic in style then write(f.f,'{\it ');
  if bold in style then write(f.f,'{\bf ');
  f.style:=style;
  f.size:=size;
end;

procedure LATEXRemoveAllStyles(var f: tLatexFile);
begin
  if bold in f.style then write(f.f,'}');
  if italic in f.style then write(f.f,'}');
  if underlined in f.style then write(f.f,'}');
  if big in f.style then write(f.f,'}');
  if sub in f.style then write(f.f,'}$');
  if super in f.style then write(f.f,'}$');
  f.style:=[];
end;

procedure LATEXStartTheBibliography(var f: tLatexFile; muster_marke: string);
begin
  WriteLn(f.f,'');
  WriteLn(f.f,'');
  WriteLn(f.f,'\begin{thebibliography}{'+muster_marke+'}');
end;

procedure LATEXStopTheBibliography(var f: tLatexFile);
begin
  WriteLn(f.f,'');
  WriteLn(f.f,'\end{thebibliography}');
end;

procedure LATEXWriteBibItem(var f: tLatexFile; mark, id:string);
begin
  WriteLn(f.f,'');
  Write(f.f,'  \bibitem');
  if mark<>'' then Write(f.f, '['+mark+']');
  Write(f.f, '{'+id+'} ');
end;


(*function LATEXExtractText(latex: string): string;
const tkText=0;
      tkInstruction=1;
      tkOptional=2;
      tkParameter=3;
var textKind:Byte;
    parameter, res:string;
    len, i, depth:longint;
begin
  depth:=1;
  len:=length(latex);
  res:='';
  parameter:='';
  textKind:=tkText;
  for i:=4 to LATEXReFormatCount-1 do
    latex:=stringreplace(latex,LATEXReFormat[i,2], LATEXReFormat[i,1],[rfReplaceAll]);

  for i:=1 to len do begin
    if (textkind=tkInstruction)and(latex[i] in ['}', ']', ' ', '$'])and(depth=1) then textkind:=tkText;
    if (textkind in [tkOptional, tkParameter]) and (latex[i] in ['[', '{']) then inc(depth);
    if (textkind in [tkOptional, tkParameter]) and (latex[i] in [']', '}']) then dec(depth);
    if (textkind=tkInstruction)and(latex[i]='[') then begin textkind:=tkOptional; depth:=1; end;
    if (textkind=tkInstruction)and(latex[i]='{') then begin textkind:=tkParameter; depth:=1; end;
    if (textKind=tkText)and(latex[i]='\')then textKind:=tkInstruction;

    if (textKind=tkText) then res:=res+latex[i];

    if (textkind=tkOptional)and(latex[i]=']')and(depth=1) then textkind:=tkInstruction;
  end;

  result:=res;
end;*)

function LATEXCleanUp(latex:string):string;
var s:string;
begin
    s:=latex;
    s:=stringReplace(s, '{\bf }', '', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '$^{ }$', '', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '$_{ }$', '', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '$^{}$', '', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '$_{}$', '', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '{\sc }', '', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '{\it }', '', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '\underline{ }', '', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '\\'#13#10'\\', '\\ \\ ', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '\\'#13#10'}', '\\}', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '^{\\'#13#10'}', '\\', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '^{\\'#10'}', '\\', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '^{\\'#13'}', '\\', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '{\bf \\'#13#10'}\\', '\par ', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '{\sc \\'#13#10'}\\', '\par ', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '{\it \\'#13#10'}\\', '\par ', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '$\\$', '\\', [rfReplaceAll, rfIgnoreCase]);
    s:=stringReplace(s, '$$', '', [rfReplaceAll, rfIgnoreCase]);
    result:=s;
end;
                                
end.
