/*******************************************************************************
  Basisprogramm zur 2D-Visualisierung mit OpenGL
  - Punkte (x,y) werden mit PlotSquare gezeichnet
    Die Farbe wird als RGB-Wert (r,g,b) mit 0<=r,g,b<=1 bergeben
*******************************************************************************/

#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <string.h>
#include <GL/glui.h>
#include <GL/glut.h>

using namespace std;

int   main_window;
ofstream* file;

float variation=10.0;
float **X, **Y;
float **neuX, **neuY;
float dt=0.02;
float startX=5.0;
float startY=5.0;
float A=1.0;
float B=3.0;
float k1=1.0;
float k2=1.0;
float k3=1.0;
float k4=1.0;
float DX=0.08;
float DY=0.003;
int width=150;
int height=150;
int cleanwidth=0;
int cleanheight=0;
int bordercond=1;
unsigned long stepcount=0;
bool clean=false;
bool simulate=false; // is beeing set true, if simulation is started


void PlotSquare (float x, float y, float r, float g, float b); // forward-Deklaration

// Zufallszahl zwischen 0 und max
float rand(float max) {
  return max*(((float)rand())/(float)RAND_MAX);
}

// variiert base um +/- (percent*base/100.0)
float rand(float base, float percent) {
  float max=base*percent/100.0;
  return base+(2.0*max*(((float)rand())/RAND_MAX)-max);
}






//******************************************************************************
//******************************************************************************

// hier den Simulationscode reinschreiben
void simStep() {
  for (int i=1; i<width-1; i++) {
    for (int j=1; j<height-1; j++) {
    
      //border conditions
      float xl=X[i-1][j];
      float xr=X[i+1][j];
      float xo=X[i][j+1];
      float xu=X[i][j-1];
      float yl=Y[i-1][j];
      float yr=Y[i+1][j];
      float yo=Y[i][j+1];
      float yu=Y[i][j-1];
      
      if (bordercond==3) { // Spiegelnder Rand
        if (i==1) {xl=X[i][j]; yl=Y[i][j];} 
        if (i==width-1) {xr=X[i][j]; yr=Y[i][j];} 
        if (j==1) {xu=X[j][j]; yu=Y[j][j];} 
        if (j==height-1) {xo=X[j][j]; yo=Y[j][j];} 
      } else {
      }

      
        neuX[i][j] = X[i][j] + dt*DX*((xl + xr + xo + xu)/4.0 - X[i][j]);
        neuY[i][j] = Y[i][j] + dt*DY*((yl + yr + yo + yu)/4.0 - Y[i][j]);
      
      neuX[i][j] = neuX[i][j] + dt*(k1*A + k2*X[i][j]*X[i][j]*Y[i][j] - k3*B*X[i][j] - k4*X[i][j]);
      neuY[i][j] = neuY[i][j] + dt*(k3*B*X[i][j]-k2*X[i][j]*X[i][j]*Y[i][j]);
      
      // Begrenzung auf [0..10] fr X,Y uminstabilitten in Numerik zu umgehen 
      if (neuX[i][j]<0.0) neuX[i][j]=0.0;
      if (neuY[i][j]<0.0) neuY[i][j]=0.0;
      if (neuX[i][j]>10.0) neuX[i][j]=10.0;
      if (neuY[i][j]>10.0) neuY[i][j]=10.0;
    }
  }
  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      X[i][j]=neuX[i][j];
      Y[i][j]=neuY[i][j];
    }
  }
  *file<<stepcount<<", "<<X[10][10]<<", "<<Y[10][10]<<endl;
}


// hier Code zur Initialisierung
void simInit() {
  X=new float*[width];
  Y=new float*[width];
  neuX=new float*[width];
  neuY=new float*[width];
  for (int i=0; i<width; i++) {
    X[i]=new float[height];
    Y[i]=new float[height];
    neuX[i]=new float[height];
    neuY[i]=new float[height];
  }

  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      X[i][j]=rand(startX);//rand(startX, variation);
      Y[i][j]=rand(startY);//rand(startY, variation);
      if ((i==0)||(i==width-1)||(j==0)||(j==height-1)) {
        if ((bordercond==0)||(bordercond==2)||(bordercond==3)) {
          X[i][j]=0;
          Y[i][j]=0;
        }
      }
      neuX[i][j]=X[i][j];
      neuY[i][j]=Y[i][j];
    }
  }
}

// hier Code zum Zeichnen
void simPlot() {
  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      float r=X[i][j]/5.0;
      PlotSquare(i, j, r, 0.0, 1.0-r);
    }
  }
}

// Speicher freigeben usw.
void simClean() {
  delete[] X;
  delete[] Y;
  delete[] neuX;
  delete[] neuY;
}

//******************************************************************************
//******************************************************************************








void init(){
   glutReshapeWindow(4*width+20,4*height+20);
}

void PlotSquare (float x, float y, float r, float g, float b) {
  float faktor=4.0;
  glBegin(GL_QUADS); // Quadrat zeichnen
  	glColor3f(r,g,b);
  	glVertex2d(faktor*(x-(0.5)), faktor*(y+(0.5))); // Top Left
  	glVertex2d(faktor*(x-(0.5)), faktor*(y-(0.5))); // Top Right
  	glVertex2d(faktor*(x+(0.5)), faktor*(y-(0.5))); // Bottom Right
  	glVertex2d(faktor*(x+(0.5)), faktor*(y+(0.5))); // Bottom Left
  glEnd(); 
}

void display(void)
{
  //Freigabe des Farb- und Tiefenpuffers
  if (simulate) {
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  	simPlot(); 	

    glFlush();
    glutSwapBuffers ();
  }
}




/***************************************** myGlutIdle() ***********/

void myGlutIdle( void )
{
  // display() aufrufen. Dort Anzeigeroutine
  if ( glutGetWindow() != main_window ) 
    glutSetWindow(main_window);  

  glutPostRedisplay();
}    


void newFloatEdit(GLUI *gluiwin, char* name, float * var, float value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_FLOAT, var);
  edit1->set_float_val(value);
}

void newIntEdit(GLUI *gluiwin, char* name, int* var, int value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_INT, var);
  edit1->set_int_val(value);
}

void newButton(GLUI *gluiwin, char* name, int id, GLUI_Update_CB callback) {
  GLUI_Button *button = gluiwin->add_button(name, id, callback);
}

void newColumn(GLUI *gluiwin){
  gluiwin->add_column(true);
}

void newSeparator(GLUI *gluiwin){
  gluiwin->add_separator();
}

void timer(int value) {
  if (simulate) {
    stepcount++;
    simStep();
    glutTimerFunc( 10, timer, 0);
  }
}


void buttonPressed (int id) {
  switch (id) {
    case 0: {
      // Start
      stepcount=0;
      if (clean) simClean();
      simInit();
      clean=true;
      init();
      simulate=true;
      glutTimerFunc( 10, timer, 0);
      break;
    }
    case 1: {
      // Stop
      simulate=false;
      break;
    }
    case 2: {
      // Go On
      simulate=true;
      glutTimerFunc( 10, timer, 0);
      break;
    }
  }
}

void reshape (int w, int h)
{
  glClearColor (1.0, 1.0, 1.0, 0.0);	//Hintergrundfarbe
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) w+20, 0.0, (GLdouble) h+20);
}


/**************************************** main() ********************/

int main(int argc, char* argv[])
{  

  file=new ofstream;
  file->open("test.txt");
  if (*file==0) {
    cout<<"File-Error!!!   test.txt"<<endl;
    system("PAUSE");
  }

  simulate=false;
  clean=false;
  srand(static_cast<unsigned>(time(NULL)));
  
  glutInit(&argc, argv);
  
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH );
  glutInitWindowPosition( 350, 50 );
  glutInitWindowSize( 500, 500 );
 
  main_window = glutCreateWindow( "Reactive Lattice Gas Automata" );
  glutDisplayFunc( display );
  glutIdleFunc( myGlutIdle );
  glutReshapeFunc( reshape );
 
 
  //Erstellung des Eingabefensters mit Hilfe von glui

  GLUI *glui= GLUI_Master.create_glui ("Eingabefenster", 0, 50, 50);
  glui->set_main_gfx_window(main_window);
  
  newIntEdit(glui, "width =", &width, 150);
  newIntEdit(glui, "height =", &height, 150);
  newSeparator(glui);
  newFloatEdit(glui, "A = ", &A, 1.0);
  newFloatEdit(glui, "B = ", &B, 3.0);
  newFloatEdit(glui, "X = ", &startX, 5.0);
  newFloatEdit(glui, "Y = ", &startY, 5.0);
  //newFloatEdit(glui, "variation [%] = ", &variation, 10.0);
  newSeparator(glui);
  newFloatEdit(glui, "Dx = ", &DX, 0.08);
  newFloatEdit(glui, "Dy = ", &DY, 0.003);
  newSeparator(glui);
  newFloatEdit(glui, "k1 = ", &k1, 1.0);
  newFloatEdit(glui, "k2 = ", &k2, 1.0);
  newFloatEdit(glui, "k3 = ", &k3, 1.0);
  newFloatEdit(glui, "k4 = ", &k4, 1.0);
  newSeparator(glui);
  newFloatEdit(glui, "dt = ", &dt, 0.02);
  GLUI_Listbox *list = glui->add_listbox("Randbedingung:", &bordercond); //listbox anlegen
  list->add_item(1, "random");
  list->add_item(2, "constant 0");
  list->add_item(3, "mirror");
  
  newColumn(glui);
  newButton(glui, "Start", 0, buttonPressed);
  newButton(glui, "Stop", 1, buttonPressed);
  newButton(glui, "Go On", 2, buttonPressed);
  
  init();

  glutMainLoop();
  
  return 0;
}



