/*******************************************************************************
  Basisprogramm zur 3D-Visualisierung mit OpenGL
  - Punkte (x,y,z) werden mit PlotSquare gezeichnet
    Die Farbe wird als RGB-Wert (r,g,b) mit 0<=r,g,b<=1 bergeben
*******************************************************************************/

#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <string.h>
#include <glui.h>
#include <GL/glut.h>

using namespace std;

int   main_window;
GLUI_Rotation *rot;
ofstream* file;

float variation=10.0;
float ***X, ***Y;
float ***neuX, ***neuY;
float dt=0.02;
float startX=5.0;
float startY=5.0;
float A=1.0;
float B=3.0;
float k1=1.0;
float k2=1.0;
float k3=1.0;
float k4=1.0;
float DX=0.2;
float DY=0.02;
float showcolor=0.6;
float notshowcolor=0.9;
int width=40;
int height=40;
int depth=40;
int cleanwidth=0;
int cleanheight=0;
int bordercond=1;
unsigned long stepcount=0;
bool clean=false;
bool simulate=false; // is beeing set true, if simulation is started


void PlotCube (float x, float y, float z, float r, float g, float b); // forward-Deklaration

// Zufallszahl zwischen 0 und max
float rand(float max) {
  return max*(((float)rand())/(float)RAND_MAX);
}

// variiert base um +/- (percent*base/100.0)
float rand(float base, float percent) {
  float max=base*percent/100.0;
  return base+(2.0*max*(((float)rand())/RAND_MAX)-max);
}






//******************************************************************************
//******************************************************************************

// hier den Simulationscode reinschreiben
void simStep() {
  for (int i=1; i<width-1; i++) {
    for (int j=1; j<height-1; j++) {
      for (int k=0; k<depth; k++) {
    
	      //border conditions
	      float xl=X[i-1][j][k];
	      float xr=X[i+1][j][k];
	      float xo=X[i][j+1][k];
	      float xu=X[i][j-1][k];
	      float xv=X[i][j][k+1];
	      float xh=X[i][j][k-1];
	      float yl=Y[i-1][j][k];
	      float yr=Y[i+1][j][k];
	      float yo=Y[i][j+1][k];
	      float yu=Y[i][j-1][k];
	      float yv=Y[i][j][k+1];
	      float yh=Y[i][j][k-1];
	      
	      if (bordercond==3) { // Spiegelnder Rand
	        if (i==1) {xl=X[i][j][k]; yl=Y[i][j][k];} 
	        if (i==width-1) {xr=X[i][j][k]; yr=Y[i][j][k];} 
	        if (j==1) {xu=X[j][j][k]; yu=Y[j][j][k];} 
	        if (j==height-1) {xo=X[j][j][k]; yo=Y[j][j][k];} 
	        if (k==1) {xh=X[j][j][k]; yh=Y[j][j][k];} 
	        if (k==height-1) {xv=X[j][j][k]; yv=Y[j][j][k];} 
	      } else {
	      }
	
	      
	        neuX[i][j][k] = X[i][j][k] + dt*DX*((xl + xr + xo + xu + xv + xh)/6.0 - X[i][j][k]);
	        neuY[i][j][k] = Y[i][j][k] + dt*DY*((yl + yr + yo + yu + yv + yh)/6.0 - Y[i][j][k]);
	      
	      neuX[i][j][k] = neuX[i][j][k] + dt*(k1*A + k2*X[i][j][k]*X[i][j][k]*Y[i][j][k] - k3*B*X[i][j][k] - k4*X[i][j][k]);
	      neuY[i][j][k] = neuY[i][j][k] + dt*(k3*B*X[i][j][k]-k2*X[i][j][k]*X[i][j][k]*Y[i][j][k]);
	      
	      // Begrenzung auf [0..10] fr X,Y uminstabilitten in Numerik zu umgehen 
	      if (neuX[i][j][k]<0.0) neuX[i][j][k]=0.0;
	      if (neuY[i][j][k]<0.0) neuY[i][j][k]=0.0;
	      if (neuX[i][j][k]>10.0) neuX[i][j][k]=10.0;
	      if (neuY[i][j][k]>10.0) neuY[i][j][k]=10.0;
      }
    }
  }
  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      for (int k=0; k<depth; k++) {
	      X[i][j][k]=neuX[i][j][k];
	      Y[i][j][k]=neuY[i][j][k];
      }
    }
  }
  *file<<stepcount<<", "<<X[10][10]<<", "<<Y[10][10]<<endl;
}


// hier Code zur Initialisierung
void simInit() {
  X=new float**[width];
  Y=new float**[width];
  neuX=new float**[width];
  neuY=new float**[width];
  for (int i=0; i<width; i++) {
    X[i]=new float*[height];
    Y[i]=new float*[height];
    neuX[i]=new float*[height];
    neuY[i]=new float*[height];
	  for (int j=0; j<height; j++) {
	    X[i][j]=new float[depth];
	    Y[i][j]=new float[depth];
	    neuX[i][j]=new float[depth];
	    neuY[i][j]=new float[depth];
	  }
  }

  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      for (int k=0; k<depth; k++) {
	      X[i][j][k]=rand(startX);//rand(startX, variation);
	      Y[i][j][k]=rand(startY);//rand(startY, variation);
	      if ((i==0)||(i==width-1)||(j==0)||(j==height-1)||(k==0)||(k==depth-1)) {
	        if ((bordercond==0)||(bordercond==2)||(bordercond==3)) {
	          X[i][j][k]=0;
	          Y[i][j][k]=0;
	        }
	      }
	      neuX[i][j][k]=X[i][j][k];
	      neuY[i][j][k]=Y[i][j][k];
      }
    }
  }
}

// hier Code zum Zeichnen
void simPlot() {
  for (int i=1; i<width-1; i++) {
    for (int j=1; j<height-1; j++) {
      for (int k=1; k<depth-1; k++) {
        float r=X[i][j][k]/5.0;
//        if ((r>showcolor)&&(r<notshowcolor)&&(!(/*(i>width/2)&&(j>height/2)&&*/(k>3.0*depth/5.0)))) PlotCube(i, j, k, r, 0.0, 1.0-r);
        if ((r>showcolor)&&(r<notshowcolor)&&(!((i>width/2)&&(j>height/2)&&(k>depth/2.0)))) PlotCube(i, j, k, r, 0.0, 1.0-r);
      }
    }
  }
}

// Speicher freigeben usw.
void simClean() {
  delete[] X;
  delete[] Y;
  delete[] neuX;
  delete[] neuY;
}

//******************************************************************************
//******************************************************************************








void init(){
  
  glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);
  glShadeModel(GL_SMOOTH);	// Enable Smooth Shading
  glClearDepth(1.0f);		// Depth Buffer Setup
  glEnable(GL_DEPTH_TEST);	// Enables Depth Testing
  glDepthFunc(GL_LESS);		// The Type Of Depth Testing To Do

  glEnable(GL_LIGHTING);
  GLfloat light_ambient[] = {0.5f,0.5f,0.5f,1.0f};

  GLfloat light_position0[] = {0.0f,1.0f,0.0f,0.0f};
  GLfloat lmodel_ambient[] = {0.2,0.2,0.2,1.0};

  glLightModelfv(GL_LIGHT_MODEL_AMBIENT ,lmodel_ambient);

  glEnable(GL_LIGHT0);
  glLightfv(GL_LIGHT0, GL_POSITION, light_position0);
  glLightfv(GL_LIGHT0, GL_AMBIENT,light_ambient);

  glEnable(GL_DEPTH_TEST);
  glEnable ( GL_COLOR_MATERIAL );

}

void PlotCube (float x, float y, float z, float r, float g, float b)
{
  

  glBegin(GL_QUAD_STRIP);
	  glColor3f(r, g, b);
	  
	  glNormal3d(0,-1,0);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  glVertex3d(x+0.5, y-0.5, z+0.5);
	  glVertex3d(x-0.5, y-0.5, z+0.5);
	  
	  glNormal3d(0,0,1);
	  glVertex3d(x+0.5, y+0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z+0.5);
	  
	  glNormal3d(0,1,0);
	  glVertex3d(x+0.5, y+0.5, z-0.5);
	  glVertex3d(x-0.5, y+0.5, z-0.5);
	  
	  glNormal3d(0,0,-1);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  
  glEnd();
  
  glBegin (GL_QUADS);
	  glColor3f(r, g, b);
	  
	  glNormal3d(1,0,0);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x+0.5, y+0.5, z-0.5);
	  glVertex3d(x+0.5, y+0.5, z+0.5);
	  glVertex3d(x+0.5, y-0.5, z+0.5);
	
	  glNormal3d(-1,0,0);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z-0.5);
	  
  glEnd();
}

void PlotCubeWire (float x, float y, float z, float dx, float dy, float dz)
{
  
  glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

  glBegin(GL_QUAD_STRIP);
	  glColor3f(0,0,0);
	  
	  glNormal3d(0,-1,0);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  glVertex3d(x+0.5, y-0.5, z+0.5);
	  glVertex3d(x-0.5, y-0.5, z+0.5);
	  
	  glNormal3d(0,0,1);
	  glVertex3d(x+0.5, y+0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z+0.5);
	  
	  glNormal3d(0,1,0);
	  glVertex3d(x+0.5, y+0.5, z-0.5);
	  glVertex3d(x-0.5, y+0.5, z-0.5);
	  
	  glNormal3d(0,0,-1);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  
  glEnd();
  
  glBegin (GL_QUADS);
	  glColor3f(0,0,0);
	  
	  glNormal3d(1,0,0);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x+0.5, y+0.5, z-0.5);
	  glVertex3d(x+0.5, y+0.5, z+0.5);
	  glVertex3d(x+0.5, y-0.5, z+0.5);
	
	  glNormal3d(-1,0,0);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z-0.5);
	  
  glEnd();
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
}

void PlotQuader (float a, float b, float c)
{
  glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
  
  glBegin(GL_QUAD_STRIP);
	  glColor3f(0,0,0);					//Farbe: schwarz
	  
	  glNormal3d(0,-1,0);
	  glVertex3d(a,0,0);
	  glVertex3d(0,0,0);
	  glVertex3d(a,0,c);
	  glVertex3d(0,0,c);
	  
	  glNormal3d(0,0,1);
	  glVertex3d(a,b,c);
	  glVertex3d(0,b,c);
	  
	  glNormal3d(0,1,0);
	  glVertex3d(a,b,0);
	  glVertex3d(0,b,0);
	  
	  glNormal3d(0,0,-1);
	  glVertex3d(a,0,0);
	  glVertex3d(0,0,0);
	  
  glEnd();
  
  glBegin (GL_QUADS);
	  glColor3f(0,0,0);
	  
	  glNormal3d(1,0,0);
	  glVertex3d(a,0,0);
	  glVertex3d(a,b,0);
	  glVertex3d(a,b,c);
	  glVertex3d(a,0,c);
	
	  glNormal3d(-1,0,0);
	  glVertex3d(0,0,0);
	  glVertex3d(0,0,c);
	  glVertex3d(0,b,c);
	  glVertex3d(0,b,0);
	  
  glEnd();
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);


}

void display(void)
{
  glutSetWindow (main_window);
  
  if (simulate) {
  
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glClearColor (1.0, 1.0, 1.0, 1.0);
    float* rotat;
    rot->get_float_array_val(rotat);

    glPushMatrix();
    glMultMatrixf(rotat);
  

    PlotQuader (width,height,depth);
    simPlot(); 	
    
    glMultMatrixf(rotat);
    glPopMatrix();
    glFlush();
    glutSwapBuffers ();
  }
}




/***************************************** myGlutIdle() ***********/

void myGlutIdle( void )
{
  // display() aufrufen. Dort Anzeigeroutine
  if ( glutGetWindow() != main_window ) 
    glutSetWindow(main_window);  
	
  glutPostRedisplay();
}    


void newFloatEdit(GLUI *gluiwin, char* name, float * var, float value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_FLOAT, var);
  edit1->set_float_val(value);
}

void newIntEdit(GLUI *gluiwin, char* name, int* var, int value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_INT, var);
  edit1->set_int_val(value);
}

void newButton(GLUI *gluiwin, char* name, int id, GLUI_Update_CB callback) {
  GLUI_Button *button = gluiwin->add_button(name, id, callback);
}

void newColumn(GLUI *gluiwin){
  gluiwin->add_column(true);
}

void newSeparator(GLUI *gluiwin){
  gluiwin->add_separator();
}

void timer(int value) {
  if (simulate) {
    stepcount++;
    simStep();
    glutTimerFunc( 10, timer, 0);
  }
}


void buttonPressed (int id) {
  switch (id) {
    case 0: {
      // Start
      stepcount=0;
      if (clean) simClean();
      simInit();
      clean=true;
      init();
      simulate=true;
      glutTimerFunc( 10, timer, 0);
      break;
    }
    case 1: {
      // Stop
      simulate=false;
      break;
    }
    case 2: {
      // Go On
      simulate=true;
      glutTimerFunc( 10, timer, 0);
      break;
    }
  }
}

void reshape (int w, int h)
{
  //glClearColor (1.0, 1.0, 1.0, 0.0);				//Hintergrundfarbe weiss
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();

  //einstellen der perspektivischen Sicht
  gluPerspective(45.0, (float)w/(float)h, 1.0, 4000.0);

  //Umschalten auf "Modellmatrix"
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  //lege die Kameraposition fest
  gluLookAt( 4*width/5, height*1.5, depth*4.0, width/2, height/2, depth/2, 0,1,0); 
  /*
    gluLookAt(eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz)
    
    (eyex, eyey, eyez) gibt die Position der Kamera an. Da der Fisch im 1. Oktanten
                       liegt und dort etwa zwischen (0,0,0) und (20,20,20), steht die Kamera
                       auf (50,20,50).
    (centerx, centery, centerz) gibt an, auf welchen Punkt die Kamera schauen soll.
                       hier ist das ein Punkt innerhalb des Fisches (30,10,10).
    (upx, upy, upz)    gibt einen Vektor vor, der angibt, in welche Richtung die Kamera schauen
    				   soll. Dieser steht senkrecht	auf der Kamera. Da die y-Achse nach oben
    				   zeigt wird dieser Vektor parallel zur y-Achse angegeben (0,1,0) und der
    				   Fisch erscheint richtig rum. mit (0,-1,0) steht er auf dem Kopf
    				   
     Ich habe zur Kennzeichnung des Ursprunges einen kleinen Wrfel (Kantenlnge 1) dort angebrtacht
     Er wird zwischen den Punkten (0,0,0) und (1,1,1) aufgespannt.
  */

}


/**************************************** main() ********************/

int main(int argc, char* argv[])
{  

  file=new ofstream;
  file->open("test.txt");
  if (*file==0) {
    cout<<"File-Error!!!   test.txt"<<endl;
    system("PAUSE");
  }

  simulate=false;
  clean=false;
  srand(static_cast<unsigned>(time(NULL)));
  
  glutInit(&argc, argv);
  
  glutInitDisplayMode( GLUT_RGBA | GLUT_DOUBLE);// | GLUT_DEPTH  );
  glutInitWindowPosition( 350, 50 );
  glutInitWindowSize( 500, 500 );
 
  main_window = glutCreateWindow( "Reactive Lattice Gas Automata" );
  glutDisplayFunc( display );
  glutIdleFunc( myGlutIdle );
  glutReshapeFunc( reshape );
 
 
  //Erstellung des Eingabefensters mit Hilfe von glui

  GLUI *glui= GLUI_Master.create_glui ("Eingabefenster", 0, 50, 50);
  glui->set_main_gfx_window(main_window);
  
  newIntEdit(glui, "width =", &width, 40);
  newIntEdit(glui, "height =", &height, 40);
  newIntEdit(glui, "depth =", &depth, 40);
  newSeparator(glui);
  newFloatEdit(glui, "A = ", &A, 1.0);
  newFloatEdit(glui, "B = ", &B, 3.0);
  newFloatEdit(glui, "X = ", &startX, 5.0);
  newFloatEdit(glui, "Y = ", &startY, 5.0);
  //newFloatEdit(glui, "variation [%] = ", &variation, 10.0);
  newSeparator(glui);
  newFloatEdit(glui, "Dx = ", &DX, 0.2);
  newFloatEdit(glui, "Dy = ", &DY, 0.02);
  newSeparator(glui);
  newFloatEdit(glui, "k1 = ", &k1, 1.0);
  newFloatEdit(glui, "k2 = ", &k2, 1.0);
  newFloatEdit(glui, "k3 = ", &k3, 1.0);
  newFloatEdit(glui, "k4 = ", &k4, 1.0);
  newSeparator(glui);
  newFloatEdit(glui, "dt = ", &dt, 0.02);
  newSeparator(glui);
  newFloatEdit(glui, "Darstellen ab = ", &showcolor, 0.6);
  newFloatEdit(glui, "Darstellen bis = ", &notshowcolor, 0.9);
  GLUI_Listbox *list = glui->add_listbox("Randbedingung:", &bordercond); //listbox anlegen
  list->add_item(1, "random");
  list->add_item(2, "constant 0");
  list->add_item(3, "mirror");
  
  newColumn(glui);
  newButton(glui, "Start", 0, buttonPressed);
  newButton(glui, "Stop", 1, buttonPressed);
  newButton(glui, "Go On", 2, buttonPressed);
  newSeparator(glui);
  rot=glui->add_rotation("Rotation:");
  
  init();

  glutMainLoop();
  
  return 0;
}



