/*******************************************************************************
  Sandpile-Modell
  (c) 2004 by Jan Krieger  
*******************************************************************************/

#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <string.h>
#include <GL/glui.h>
#include <math.h>
#include <GL/glut.h>

using namespace std;

int   main_window;
ofstream* file;

int *H;
int *neuH;
int rradius=15;
int criticalslope=4;

int state=0; // 0: rieseln;    1: Lawine

#define timestep 00
#define zfaktor 2
#define windowheight 800

int width=150;
int cleanwidth=0;
int bordercond=1;
unsigned long stepcount=0;
bool clean=false;
bool simulate=false; // is beeing set true, if simulation is started


void PlotSquare (float x, float y, float r, float g, float b); // forward-Deklaration

// Zufallszahl zwischen 0 und max
float rand(float max) {
  return max*(((float)rand())/(float)RAND_MAX);
}

// variiert base um +/- (percent*base/100.0)
float rand(float base, float percent) {
  float max=base*percent/100.0;
  return base+(2.0*max*(((float)rand())/RAND_MAX)-max);
}






//******************************************************************************
//******************************************************************************

// hier den Simulationscode reinschreiben
void simStep() {
  //*file<<"["<<stepcount<<"]: "<<endl;
  if (state==0) {
  	  unsigned int pos=(unsigned int)trunc(rand(2*rradius));
  	  pos=(width/2)+pos-rradius;
  	  H[pos]=H[pos]+1;
  	  state=1;
  	  /**file<<"   rain: "<<pos<<endl;
  	  *file<<"         ";
  	  for (int i=0; i<width; i++) {*file<<H[i]<<"\t";}
  	  *file<<endl;*/
  } else {
/*  	  *file<<"   fall: ";
  	  for (int i=0; i<width; i++) {*file<<H[i]<<"\t";}
  	  *file<<endl;*/
      state=0;
      // while-Schleife wird implizit mit state realisiert. state bleibt 1, solange sich was ndert
      
      // Spezialfall: Zelle x=0 (ganz links)
      neuH[0]=H[0];
      if ((neuH[0]>0)&&(H[0]>(H[1]+criticalslope))) { state=1; neuH[0]= neuH[0]-1; } // oberste Zelle stirbt
      if ((neuH[0]>0)&&(H[0]>criticalslope)) { state=1; neuH[0]= neuH[0]-1; } // nach links rieselt's immer ab
      if (H[0]<(H[1]-criticalslope)) { state=1; neuH[0]= neuH[0]+1; } // oberste Zelle stirbt
      
      // Spezialfall: Zelle x=width-1 (ganz rechts)
      neuH[width-1]=H[width-1];
      if ((neuH[width-1]>0)&&(H[width-1]>(H[width-2]+criticalslope))) { state=1; neuH[width-1]= neuH[width-1]-1; } // oberste Zelle stirbt
      if ((neuH[width-1]>0)&&(H[width-1]>criticalslope)) { state=1; neuH[width-1]= neuH[width-1]-1; } // nach rechts rieselts immer ab
      if (H[width-1]<(H[width-2]-criticalslope)) { state=1; neuH[width-1]= neuH[width-1]+1; } // oberste Zelle stirbt
      
      
      // normaler Fall 
	  for (int i=1; i<width-1; i++) {
        neuH[i]=H[i];
	  	if ((neuH[i]>0)&&(H[i]>(H[i+1]+criticalslope))) { state=1; neuH[i]=neuH[i]-1; }
	  	if ((neuH[i]>0)&&(H[i]>(H[i-1]+criticalslope))) { state=1; neuH[i]=neuH[i]-1; }
	  	if (H[i]<(H[i+1]-criticalslope)) { state=1; neuH[i]=neuH[i]+1; }
	  	if (H[i]<(H[i-1]-criticalslope)) { state=1; neuH[i]=neuH[i]+1; }
	  }
	  for (int i=0; i<width; i++) {
	    H[i]=neuH[i];
	  }
/*  	  *file<<"         ";
  	  for (int i=0; i<width; i++) {*file<<H[i]<<"\t";}
  	  *file<<endl;*/
 }
}


// hier Code zur Initialisierung
void simInit() {
  H=new int[width];
  neuH=new int[width];
  for (int i=0; i<width; i++) {
    H[i]=0;
    neuH[i]=0;
  }
}

// hier Code zum Zeichnen
void simPlot() {
  for (int i=0; i<width; i++) {
    for (int j=0; j<H[i]; j++) {
      float r=1.0;
      //if (state==0) r=0.0;
      PlotSquare(i, j, r, 0.0, 0.0);
    }
  }
}

// Speicher freigeben usw.
void simClean() {
  delete[] H;
  delete[] neuH;
}

//******************************************************************************
//******************************************************************************












void init(){
   glutReshapeWindow(zfaktor*width+20,windowheight);
}

void PlotSquare (float x, float y, float r, float g, float b) {
  float faktor=zfaktor;
  glBegin(GL_QUADS); // Quadrat zeichnen
  	glColor3f(r,g,b);
  	glVertex2d(faktor*(x-(0.5)), faktor*(y+(0.5))); // Top Left
  	glVertex2d(faktor*(x-(0.5)), faktor*(y-(0.5))); // Top Right
  	glVertex2d(faktor*(x+(0.5)), faktor*(y-(0.5))); // Bottom Right
  	glVertex2d(faktor*(x+(0.5)), faktor*(y+(0.5))); // Bottom Left
  glEnd(); 
}

void display(void)
{
  //Freigabe des Farb- und Tiefenpuffers
  if (simulate) {
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  	simPlot(); 	

    glFlush();
    glutSwapBuffers ();
  }
}




/***************************************** myGlutIdle() ***********/

void myGlutIdle( void )
{
  // display() aufrufen. Dort Anzeigeroutine
  if ( glutGetWindow() != main_window ) 
    glutSetWindow(main_window);  

  glutPostRedisplay();
}    


void newFloatEdit(GLUI *gluiwin, char* name, float * var, float value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_FLOAT, var);
  edit1->set_float_val(value);
}

void newIntEdit(GLUI *gluiwin, char* name, int* var, int value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_INT, var);
  edit1->set_int_val(value);
}

void newButton(GLUI *gluiwin, char* name, int id, GLUI_Update_CB callback) {
  GLUI_Button *button = gluiwin->add_button(name, id, callback);
}

void newColumn(GLUI *gluiwin){
  gluiwin->add_column(true);
}

void newSeparator(GLUI *gluiwin){
  gluiwin->add_separator();
}

void timer(int value) {
  if (simulate) {
    stepcount++;
    simStep();
    glutTimerFunc( timestep, timer, 0);
  }
  glutPostRedisplay();
}


void buttonPressed (int id) {
  switch (id) {
    case 0: {
      // Start
      stepcount=0;
      if (clean) simClean();
      simInit();
      clean=true;
      init();
      simulate=true;
      glutTimerFunc( timestep, timer, 0);
      break;
    }
    case 1: {
      // Stop
      simulate=false;
      break;
    }
    case 2: {
      // Go On
      simulate=true;
      glutTimerFunc( timestep, timer, 0);
      break;
    }
  }
}

void reshape (int w, int h)
{
  glClearColor (1.0, 1.0, 1.0, 0.0);	//Hintergrundfarbe
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) w+20, 0.0, (GLdouble) h+20);
}


/**************************************** main() ********************/

int main(int argc, char* argv[])
{  

  file=new ofstream;
  file->open("lawine.txt");
  if (*file==0) {
    cout<<"File-Error!!!   test.txt"<<endl;
    system("PAUSE");
  }

  simulate=false;
  clean=false;
  srand(static_cast<unsigned>(time(NULL)));
  
  glutInit(&argc, argv);
  
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH );
  glutInitWindowPosition( 350, 50 );
  glutInitWindowSize( 500, 500 );
 
  main_window = glutCreateWindow( "Reactive Lattice Gas Automata" );
  glutDisplayFunc( display );
  glutIdleFunc( myGlutIdle );
  glutReshapeFunc( reshape );
 
 
  //Erstellung des Eingabefensters mit Hilfe von glui

  GLUI *glui= GLUI_Master.create_glui ("Eingabefenster", 0, 50, 50);
  glui->set_main_gfx_window(main_window);
  
  newIntEdit(glui, "width =", &width, 300);
  newSeparator(glui);
  newIntEdit(glui, "Rieselradius = ", &rradius, 50);
  newIntEdit(glui, "kritische Steigung = ", &criticalslope, 4);
  newColumn(glui);
  newButton(glui, "Start", 0, buttonPressed);
  newButton(glui, "Stop", 1, buttonPressed);
  newButton(glui, "Go On", 2, buttonPressed);
  
  init();

  glutMainLoop();
  
  return 0;
}



