/*******************************************************************************
  Sandpile-Modell, 3D
  (c) 2004 by Jan Krieger --- jan@jkrieger.de -- www.jkrieger.de
*******************************************************************************/

#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <string.h>
#include <GL/glui.h>
#include <GL/glut.h>

using namespace std;

int   main_window;
GLUI_Rotation *rot;
ofstream* file, *lfile;

int **H;
int **neuH;
int rradius=10;
int criticalslope=2;
unsigned long lawinesize=0;
unsigned long lawinecount=0;
int lawinen[10000];

int state=0; // 0: rieseln;    1: Lawine

#define timestep 10
#define depth 70

int width=50;
int height=50;
int cleanwidth=0;
int cleanheight=0;
int bordercond=1;
unsigned long stepcount=0;
bool clean=false;
bool simulate=false; // is beeing set true, if simulation is started


void PlotCube (float x, float y, float z, float r, float g, float b); // forward-Deklaration

// Zufallszahl zwischen 0 und max
float rand(float max) {
  return max*(((float)rand())/(float)RAND_MAX);
}

// variiert base um +/- (percent*base/100.0)
float rand(float base, float percent) {
  float max=base*percent/100.0;
  return base+(2.0*max*(((float)rand())/RAND_MAX)-max);
}






//******************************************************************************
//******************************************************************************
void simStop() {
  lfile=new ofstream;
  lfile->open("lawine_statistik.txt");
  for (int i=1; i<10000; i++) {
    *lfile<<i<<", "<<lawinen[i]<<endl;   
  }    
  lfile->close();
  delete lfile;
}

    
// hier den Simulationscode reinschreiben
void simStep() {
  //*file<<stepcount<<", "<<endl;
  if (state==0) {
  	  unsigned int pos=(unsigned int)trunc(rand(2*rradius));
  	  unsigned int posx=(width/2)+pos-rradius;
  	  pos=(unsigned int)trunc(rand(2*rradius));
  	  unsigned int posy=(height/2)+pos-rradius;
  	  //*file<<"   rain: "<<posx<<", "<<posy<<endl;
  	  H[posx][posy]=H[posx][posy]+1;
  	  lawinecount++;
  	  lawinen[lawinesize]+=1;
  	  *file<<lawinecount<<", "<<lawinesize<<endl;
  	  lawinesize=0;
  	  state=1;
  	  /**file<<"         ";
  	  for (int i=0; i<width; i++) {*file<<H[i][i]<<"\t";}
  	  *file<<endl;*/
  } else {
  	  /**file<<"   fall: ";
  	  for (int i=0; i<width; i++) {*file<<H[i][i]<<"\t";}
  	  *file<<endl;*/
      state=0;
      // while-Schleife wird implizit mit state realisiert. state bleibt 1, solange sich was ndert
      
      // Spezialfall: Zelle x=0 (ganz links)
/*      neuH[0]=H[0];
      if ((neuH[0]>0)&&(H[0]>(H[1]+criticalslope))) { state=1; neuH[0]= neuH[0]-1; } // oberste Zelle stirbt
      if ((neuH[0]>0)&&(H[0]>criticalslope)) { state=1; neuH[0]= neuH[0]-1; } // nach links rieselt's immer ab
      if (H[0]<(H[1]-criticalslope)) { state=1; neuH[0]= neuH[0]+1; } // oberste Zelle stirbt
      
      // Spezialfall: Zelle x=width-1 (ganz rechts)
      neuH[width-1]=H[width-1];
      if ((neuH[width-1]>0)&&(H[width-1]>(H[width-2]+criticalslope))) { state=1; neuH[width-1]= neuH[width-1]-1; } // oberste Zelle stirbt
      if ((neuH[width-1]>0)&&(H[width-1]>criticalslope)) { state=1; neuH[width-1]= neuH[width-1]-1; } // nach rechts rieselts immer ab
      if (H[width-1]<(H[width-2]-criticalslope)) { state=1; neuH[width-1]= neuH[width-1]+1; } // oberste Zelle stirbt*/
      
      
      // normaler Fall 
	  for (int i=1; i<width-1; i++) {
	      for (int j=1; j<height-1; j++) {
            neuH[i][j]=H[i][j];
    	  	if ((neuH[i][j]>0)&&(H[i][j]>(H[i+1][j]+criticalslope))) { state=1; neuH[i][j]=neuH[i][j]-1; lawinesize++;}
    	  	if ((neuH[i][j]>0)&&(H[i][j]>(H[i-1][j]+criticalslope))) { state=1; neuH[i][j]=neuH[i][j]-1; lawinesize++;}
    	  	if ((neuH[i][j]>0)&&(H[i][j]>(H[i][j+1]+criticalslope))) { state=1; neuH[i][j]=neuH[i][j]-1; lawinesize++;}
    	  	if ((neuH[i][j]>0)&&(H[i][j]>(H[i][j-1]+criticalslope))) { state=1; neuH[i][j]=neuH[i][j]-1; lawinesize++;}
    	  	if (H[i][j]<(H[i+1][j]-criticalslope)) { state=1; neuH[i][j]=neuH[i][j]+1; lawinesize++;}
    	  	if (H[i][j]<(H[i-1][j]-criticalslope)) { state=1; neuH[i][j]=neuH[i][j]+1; lawinesize++;}
    	  	if (H[i][j]<(H[i][j+1]-criticalslope)) { state=1; neuH[i][j]=neuH[i][j]+1; lawinesize++;}
    	  	if (H[i][j]<(H[i][j-1]-criticalslope)) { state=1; neuH[i][j]=neuH[i][j]+1; lawinesize++;}
  	  	  }	  	
	  }
	  for (int i=0; i<width; i++) {
	    for (int j=0; j<height; j++) {  
          H[i][j]=neuH[i][j];
        }    
	  }
  	  /**file<<"         ";
  	  for (int i=0; i<width; i++) {*file<<H[i][i]<<"\t";}
  	  *file<<endl;*/
 }
}


// hier Code zur Initialisierung
void simInit() {
  /**file<<"initializing..."<<endl;*/
  *file<<"#  criticalslope = "<<criticalslope<<endl;
  *file<<"#  rradius = "<<rradius<<endl;
  H=new int*[width];
  neuH=new int*[width];
  for (int i=0; i<width; i++) {
    H[i]=new int[height];
    neuH[i]=new int[height];
	  for (int j=0; j<height; j++) {
	    H[i][j]=0;
	    neuH[i][j]=0;
	  }
  }
//  *file<<"initialized..."<<endl;
}

// hier Code zum Zeichnen
void simPlot() {
  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      for (int k=0; k<H[i][j]; k++) {
          PlotCube(i, k, j, 0, 0, 1.0);
      }
    }
  }
}

// Speicher freigeben usw.
void simClean() {
}

//******************************************************************************
//******************************************************************************








void init(){
  
  glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);
  glShadeModel(GL_SMOOTH);	// Enable Smooth Shading
  glClearDepth(1.0f);		// Depth Buffer Setup
  glEnable(GL_DEPTH_TEST);	// Enables Depth Testing
  glDepthFunc(GL_LESS);		// The Type Of Depth Testing To Do

  glEnable(GL_LIGHTING);
  GLfloat light_ambient[] = {0.5f,0.5f,0.5f,1.0f};

  GLfloat light_position0[] = {0.0f,1.0f,0.0f,0.0f};
  GLfloat lmodel_ambient[] = {0.2,0.2,0.2,1.0};

  glLightModelfv(GL_LIGHT_MODEL_AMBIENT ,lmodel_ambient);

  glEnable(GL_LIGHT0);
  glLightfv(GL_LIGHT0, GL_POSITION, light_position0);
  glLightfv(GL_LIGHT0, GL_AMBIENT,light_ambient);

  glEnable(GL_DEPTH_TEST);
  glEnable ( GL_COLOR_MATERIAL );

}

void PlotCube (float x, float y, float z, float r, float g, float b)
{
  

  glBegin(GL_QUAD_STRIP);
	  glColor3f(r, g, b);
	  
	  glNormal3d(0,-1,0);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  glVertex3d(x+0.5, y-0.5, z+0.5);
	  glVertex3d(x-0.5, y-0.5, z+0.5);
	  
	  glNormal3d(0,0,1);
	  glVertex3d(x+0.5, y+0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z+0.5);
	  
	  glNormal3d(0,1,0);
	  glVertex3d(x+0.5, y+0.5, z-0.5);
	  glVertex3d(x-0.5, y+0.5, z-0.5);
	  
	  glNormal3d(0,0,-1);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  
  glEnd();
  
  glBegin (GL_QUADS);
	  glColor3f(r, g, b);
	  
	  glNormal3d(1,0,0);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x+0.5, y+0.5, z-0.5);
	  glVertex3d(x+0.5, y+0.5, z+0.5);
	  glVertex3d(x+0.5, y-0.5, z+0.5);
	
	  glNormal3d(-1,0,0);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z-0.5);
	  
  glEnd();
}

void PlotCubeWire (float x, float y, float z, float dx, float dy, float dz)
{
  
  glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

  glBegin(GL_QUAD_STRIP);
	  glColor3f(0,0,0);
	  
	  glNormal3d(0,-1,0);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  glVertex3d(x+0.5, y-0.5, z+0.5);
	  glVertex3d(x-0.5, y-0.5, z+0.5);
	  
	  glNormal3d(0,0,1);
	  glVertex3d(x+0.5, y+0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z+0.5);
	  
	  glNormal3d(0,1,0);
	  glVertex3d(x+0.5, y+0.5, z-0.5);
	  glVertex3d(x-0.5, y+0.5, z-0.5);
	  
	  glNormal3d(0,0,-1);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  
  glEnd();
  
  glBegin (GL_QUADS);
	  glColor3f(0,0,0);
	  
	  glNormal3d(1,0,0);
	  glVertex3d(x+0.5, y-0.5, z-0.5);
	  glVertex3d(x+0.5, y+0.5, z-0.5);
	  glVertex3d(x+0.5, y+0.5, z+0.5);
	  glVertex3d(x+0.5, y-0.5, z+0.5);
	
	  glNormal3d(-1,0,0);
	  glVertex3d(x-0.5, y-0.5, z-0.5);
	  glVertex3d(x-0.5, y-0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z+0.5);
	  glVertex3d(x-0.5, y+0.5, z-0.5);
	  
  glEnd();
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
}

void PlotQuader (float a, float b, float c)
{
  glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
  
  glBegin(GL_QUAD_STRIP);
	  glColor3f(0,0,0);					//Farbe: schwarz
	  
	  glNormal3d(0,-1,0);
	  glVertex3d(a,0,0);
	  glVertex3d(0,0,0);
	  glVertex3d(a,0,c);
	  glVertex3d(0,0,c);
	  
	  glNormal3d(0,0,1);
	  glVertex3d(a,b,c);
	  glVertex3d(0,b,c);
	  
	  glNormal3d(0,1,0);
	  glVertex3d(a,b,0);
	  glVertex3d(0,b,0);
	  
	  glNormal3d(0,0,-1);
	  glVertex3d(a,0,0);
	  glVertex3d(0,0,0);
	  
  glEnd();
  
  glBegin (GL_QUADS);
	  glColor3f(0,0,0);
	  
	  glNormal3d(1,0,0);
	  glVertex3d(a,0,0);
	  glVertex3d(a,b,0);
	  glVertex3d(a,b,c);
	  glVertex3d(a,0,c);
	
	  glNormal3d(-1,0,0);
	  glVertex3d(0,0,0);
	  glVertex3d(0,0,c);
	  glVertex3d(0,b,c);
	  glVertex3d(0,b,0);
	  
  glEnd();
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);


}

void display(void)
{
  glutSetWindow (main_window);
  
  if (simulate) {
  
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glClearColor (1.0, 1.0, 1.0, 1.0);
//    float *rotat;
//    rot->get_float_array_val(rotat);

    glPushMatrix();
//    glMultMatrixf(rotat);
  

    //PlotQuader (width,height,depth);
    simPlot(); 	
    
    //glMultMatrixf(rotat);
    glPopMatrix();
    glFlush();
    glutSwapBuffers ();
  }
}




/***************************************** myGlutIdle() ***********/

void myGlutIdle( void )
{
  // display() aufrufen. Dort Anzeigeroutine
  if ( glutGetWindow() != main_window ) 
    glutSetWindow(main_window);  
	
  glutPostRedisplay();
}    


void newFloatEdit(GLUI *gluiwin, char* name, float * var, float value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_FLOAT, var);
  edit1->set_float_val(value);
}

void newIntEdit(GLUI *gluiwin, char* name, int* var, int value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_INT, var);
  edit1->set_int_val(value);
}

void newButton(GLUI *gluiwin, char* name, int id, GLUI_Update_CB callback) {
  GLUI_Button *button = gluiwin->add_button(name, id, callback);
}

void newColumn(GLUI *gluiwin){
  gluiwin->add_column(true);
}

void newSeparator(GLUI *gluiwin){
  gluiwin->add_separator();
}

void timer(int value) {
  if (simulate) {
    stepcount++;
    simStep();
    glutTimerFunc( timestep, timer, 0);
  }
}


void buttonPressed (int id) {
  switch (id) {
    case 0: {
      // Start
      stepcount=0;
      if (clean) simClean();
      simInit();
      clean=true;
      init();
      simulate=true;
      glutTimerFunc( timestep, timer, 0);
      break;
    }
    case 1: {
      // Stop
      simulate=false;
      simStop();
      break;
    }
    case 2: {
      // Go On
      simulate=true;
      glutTimerFunc( timestep, timer, 0);
      break;
    }
  }
}

void reshape (int w, int h)
{
  //glClearColor (1.0, 1.0, 1.0, 0.0);				//Hintergrundfarbe weiss
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();

  //einstellen der perspektivischen Sicht
  gluPerspective(45.0, (float)w/(float)h, 1.0, 4000.0);

  //Umschalten auf "Modellmatrix"
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  //lege die Kameraposition fest
  gluLookAt( 30, 60, 80, width/2, 20, height/2, 0,1,0); 
  /*
    gluLookAt(eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz)
    
    (eyex, eyey, eyez) gibt die Position der Kamera an. Da der Fisch im 1. Oktanten
                       liegt und dort etwa zwischen (0,0,0) und (20,20,20), steht die Kamera
                       auf (50,20,50).
    (centerx, centery, centerz) gibt an, auf welchen Punkt die Kamera schauen soll.
                       hier ist das ein Punkt innerhalb des Fisches (30,10,10).
    (upx, upy, upz)    gibt einen Vektor vor, der angibt, in welche Richtung die Kamera schauen
    				   soll. Dieser steht senkrecht	auf der Kamera. Da die y-Achse nach oben
    				   zeigt wird dieser Vektor parallel zur y-Achse angegeben (0,1,0) und der
    				   Fisch erscheint richtig rum. mit (0,-1,0) steht er auf dem Kopf
    				   
     Ich habe zur Kennzeichnung des Ursprunges einen kleinen Wrfel (Kantenlnge 1) dort angebrtacht
     Er wird zwischen den Punkten (0,0,0) und (1,1,1) aufgespannt.
  */

}


/**************************************** main() ********************/

int main(int argc, char* argv[])
{  

  file=new ofstream;
  file->open("lawine3d.txt");
  if (*file==0) {
    cout<<"File-Error!!!   test.txt"<<endl;
    system("PAUSE");
  }

  simulate=false;
  clean=false;
  srand(static_cast<unsigned>(time(NULL)));
  
  glutInit(&argc, argv);
  
  glutInitDisplayMode( GLUT_RGBA | GLUT_DOUBLE);// | GLUT_DEPTH  );
  glutInitWindowPosition( 350, 50 );
  glutInitWindowSize( 500, 500 );
 
  main_window = glutCreateWindow( "Sandpile-Modell" );
  glutDisplayFunc( display );
  glutIdleFunc( myGlutIdle );
  glutReshapeFunc( reshape );
 
 
  //Erstellung des Eingabefensters mit Hilfe von glui

  GLUI *glui= GLUI_Master.create_glui ("Eingabefenster", 0, 50, 50);
  glui->set_main_gfx_window(main_window);

  newIntEdit(glui, "width =", &width, 50);
  newIntEdit(glui, "height =", &height, 50);
  newSeparator(glui);
  newIntEdit(glui, "Rieselradius = ", &rradius, 10);
  newIntEdit(glui, "kritische Steigung = ", &criticalslope, 2);
  
  
  newColumn(glui);
  newButton(glui, "Start", 0, buttonPressed);
  newButton(glui, "Stop", 1, buttonPressed);
  newButton(glui, "Go On", 2, buttonPressed);
  newSeparator(glui);
  rot=glui->add_rotation("Rotation:");
  
  init();

  glutMainLoop();
  
  return 0;
}



