/*******************************************************************************
  Basisprogramm zur 2D-Visualisierung mit OpenGL
  - Punkte (x,y) werden mit PlotSquare gezeichnet
    Die Farbe wird als RGB-Wert (r,g,b) mit 0<=r,g,b<=1 bergeben
*******************************************************************************/

#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <string.h>
#include <glui.h>
#include <GL/glut.h>

using namespace std;

int   main_window;
ofstream* file;

#define time_constant 100 

float prob=0.1;
float mut_prob=0.001;
char **X, **neuX;
int width=150;
int height=150;
int cleanwidth=0;
int cleanheight=0;
int bordercond=1;
unsigned long stepcount=0;
bool clean=false;
bool simulate=false; // is beeing set true, if simulation is started


void PlotSquare (float x, float y, float r, float g, float b); // forward-Deklaration

// Zufallszahl zwischen 0 und max
float rand(float max) {
  return max*(((float)rand())/(float)RAND_MAX);
}

// variiert base um +/- (percent*base/100.0)
float rand(float base, float percent) {
  float max=base*percent/100.0;
  return base+(2.0*max*(((float)rand())/RAND_MAX)-max);
}






//******************************************************************************
//******************************************************************************

// hier den Simulationscode reinschreiben
void simStep() {
  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
    
      //border conditions
      char xl=X[(unsigned int)(i-1)%width][j%height];
      char xr=X[(i+1)%width][j%height];
      char xo=X[i%width][(j+1)%height];
      char xu=X[i%width][(unsigned int)(j-1)%height];
      char xol=X[(unsigned int)(i-1)%width][(j+1)%height];
      char xorr=X[(i+1)%width][(j+1)%height];
      char xul=X[(unsigned int)(i-1)%width][(unsigned int)(j-1)%height];
      char xur=X[(i+1)%width][(unsigned int)(j-1)%height];
      
      if (bordercond==3) { // Spiegelnder Rand
/*        if (i==1) {xl=X[i][j]; } 
        if (i==width-1) {xr=X[i][j];} 
        if (j==1) {xu=X[j][j];} 
        if (j==height-1) {xo=X[j][j];} */
      } else {
      }

      int count=xl+xr+xo+xu+xol+xorr+xul+xur;
      //if ((((float)rand())/(float)RAND_MAX)<prob) count+=1;
      //if ((((float)rand())/(float)RAND_MAX)<prob) count-=1;
      neuX[i][j]=X[i][j];
      if (((count<2)||(count>3))&&((((float)rand())/(float)RAND_MAX)>prob)) neuX[i][j]=0;
      if (count==3) neuX[i][j]=1;
      
      if ((((float)rand())/(float)RAND_MAX)<mut_prob) neuX[i][j]=(neuX[i][j]+1)%2;
      
    }
  }
  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      X[i][j]=neuX[i][j];
    }
  }
  //*file<<stepcount<<", "<<X[10][10]<<", "<<Y[10][10]<<endl;
}


// hier Code zur Initialisierung
void simInit() {
  X=new char*[width];
  neuX=new char*[width];
  for (int i=0; i<width; i++) {
    X[i]=new char[height];
    neuX[i]=new char[height];
  }

  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      X[i][j]=(long)rand(2)%2;//rand(startX, variation);
      if ((i==0)||(i==width-1)||(j==0)||(j==height-1)) {
        if ((bordercond==0)||(bordercond==2)||(bordercond==3)) {
          X[i][j]=0;
        }
      }
      neuX[i][j]=X[i][j];
    }
  }
}

// hier Code zum Zeichnen
void simPlot() {
  for (int i=0; i<width; i++) {
    for (int j=0; j<height; j++) {
      char r=(char)X[i][j];
      PlotSquare((float)i, (float)j, r, 0.0, 1.0-r);
    }
  }
}

// Speicher freigeben usw.
void simClean() {
  delete[] X;
  delete[] neuX;
}

//******************************************************************************
//******************************************************************************








void init(){
   glutReshapeWindow(4*width+20,4*height+20);
}

void PlotSquare (float x, float y, float r, float g, float b) {
  float faktor=4.0;
  glBegin(GL_QUADS); // Quadrat zeichnen
  	glColor3f(r,g,b);
  	glVertex2d(faktor*(x-(0.5)), faktor*(y+(0.5))); // Top Left
  	glVertex2d(faktor*(x-(0.5)), faktor*(y-(0.5))); // Top Right
  	glVertex2d(faktor*(x+(0.5)), faktor*(y-(0.5))); // Bottom Right
  	glVertex2d(faktor*(x+(0.5)), faktor*(y+(0.5))); // Bottom Left
  glEnd(); 
}

void display(void)
{
  //Freigabe des Farb- und Tiefenpuffers
  if (simulate) {
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  	simPlot(); 	

    glFlush();
    glutSwapBuffers ();
  }
}




/***************************************** myGlutIdle() ***********/

void myGlutIdle( void )
{
  // display() aufrufen. Dort Anzeigeroutine
  if ( glutGetWindow() != main_window ) 
    glutSetWindow(main_window);  

  glutPostRedisplay();
}    


void newFloatEdit(GLUI *gluiwin, char* name, float * var, float value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_FLOAT, var);
  edit1->set_float_val(value);
}

void newIntEdit(GLUI *gluiwin, char* name, int* var, int value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_INT, var);
  edit1->set_int_val(value);
}

void newButton(GLUI *gluiwin, char* name, int id, GLUI_Update_CB callback) {
  GLUI_Button *button = gluiwin->add_button(name, id, callback);
}

void newColumn(GLUI *gluiwin){
  gluiwin->add_column(true);
}

void newSeparator(GLUI *gluiwin){
  gluiwin->add_separator();
}

void timer(int value) {
  if (simulate) {
    stepcount++;
    simStep();
    glutTimerFunc( time_constant, timer, 0);
  }
}


void buttonPressed (int id) {
  switch (id) {
    case 0: {
      // Start
      stepcount=0;
      if (clean) simClean();
      simInit();
      clean=true;
      init();
      simulate=true;
      glutTimerFunc( time_constant, timer, 0);
      break;
    }
    case 1: {
      // Stop
      simulate=false;
      break;
    }
    case 2: {
      // Go On
      simulate=true;
      glutTimerFunc( time_constant, timer, 0);
      break;
    }
  }
}

void reshape (int w, int h)
{
  glClearColor (1.0, 1.0, 1.0, 0.0);	//Hintergrundfarbe
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) w+20, 0.0, (GLdouble) h+20);
}


/**************************************** main() ********************/

int main(int argc, char* argv[])
{  

  file=new ofstream;
  file->open("gol.txt");
  if (*file==0) {
    cout<<"File-Error!!!   test.txt"<<endl;
    system("PAUSE");
  }

  simulate=false;
  clean=false;
  srand(static_cast<unsigned>(time(NULL)));
  
  glutInit(&argc, argv);
  
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH );
  glutInitWindowPosition( 350, 50 );
  glutInitWindowSize( 500, 500 );
 
  main_window = glutCreateWindow( "Reactive Lattice Gas Automata" );
  glutDisplayFunc( display );
  glutIdleFunc( myGlutIdle );
  glutReshapeFunc( reshape );
 
 
  //Erstellung des Eingabefensters mit Hilfe von glui

  GLUI *glui= GLUI_Master.create_glui ("Eingabefenster", 0, 50, 50);
  glui->set_main_gfx_window(main_window);
  
  newIntEdit(glui, "width =", &width, 150);
  newIntEdit(glui, "height =", &height, 150);
  newSeparator(glui);
  newFloatEdit(glui, "Probability =", &prob, 0.1);
  newFloatEdit(glui, "Mutation Probability =", &mut_prob, 0.001);
  newSeparator(glui);

  GLUI_Listbox *list = glui->add_listbox("Randbedingung:", &bordercond); //listbox anlegen
  list->add_item(1, "random");
  list->add_item(2, "constant 0");
  list->add_item(3, "mirror");
  
  newColumn(glui);
  newButton(glui, "Start", 0, buttonPressed);
  newButton(glui, "Stop", 1, buttonPressed);
  newButton(glui, "Go On", 2, buttonPressed);
  
  init();

  glutMainLoop();
  
  return 0;
}



