/*******************************************************************************
  Basisprogramm zur 2D-Visualisierung mit OpenGL
  - Punkte (x,y) werden mit PlotSquare gezeichnet
    Die Farbe wird als RGB-Wert (r,g,b) mit 0<=r,g,b<=1 bergeben
*******************************************************************************/

#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <cstdlib>
#include <string>
#include <string.h>
#include <glui.h>
#include <GL/glut.h>

using namespace std;

int   main_window;
ofstream* file;

float variation=10.0;
float *a, *b, *s;
float *neua, *neub;
float dt=1.0;
float starts=0.02;
float starta=1.0;
float startb=1.0;
float ra=0.02;
float rb=0.03;
float ba=0.001;
float Da=0.01;
float Db=0.4;
int width=50;
int height=100;
int cleanwidth=0;
int cleanheight=0;
int bordercond=1;
unsigned long stepcount=0;
bool clean=false;
bool simulate=false; // is beeing set true, if simulation is started


void PlotSquare (float x, float y, float r, float g, float b); // forward-Deklaration

// Zufallszahl zwischen 0 und max
float rand(float max) {
  return max*(((float)rand())/(float)RAND_MAX);
}

// variiert base um +/- (percent*base/100.0)
float rand(float base, float percent) {
  float max=base*percent/100.0;
  return base+(2.0*max*(((float)rand())/RAND_MAX)-max);
}






//******************************************************************************
//******************************************************************************

string inttostr(long data){
  ostringstream ost;
  ost<<data;
  return ost.str();
}


// hier den Simulationscode reinschreiben
void simStep() {
  string  s;
  s="./muschel/"+inttostr(stepcount)+".dat";
  file=new ofstream;
  file->open(s.c_str());
  if (*file==0) {
    system("PAUSE");
  }
  for (int j=0; j<1; j++) {	
	  for (int i=1; i<width-1; i++) {
	    neua[i]=a[i]+dt*(s[i] * a[i] * a[i] / b[i] + s[i] * ba - ra * a[i] + Da * ((a[i-1]+a[i+1])-2.0*a[i]));
	    neub[i]=b[i]+dt*(s[i] * a[i] * a[i] - rb * b[i] + Db * ((b[i-1]+b[i+1])-2.0*b[i]));
	  }
	  for (int i=0; i<width; i++) {
	      a[i]=neua[i];
	      b[i]=neub[i];
	  }
  }
  for (int i=0; i<width-1; i++) {
    *file << i<<", "<< a[i]<<", "<< b[i]<<", "<< s[i]<<endl;
  }
  delete file;
}


// hier Code zur Initialisierung
void simInit() {
  s=new float[width];
  a=new float[width];
  b=new float[width];
  neua=new float[width];
  neub=new float[width];
  for (int i=0; i<width; i++) {
    a[i]=starta;
    b[i]=startb;
    neua[i]=a[i];
    neub[i]=b[i];
    s[i]=ra*(0.995+0.1*((float)rand())/((float)RAND_MAX));//rand(starts, variation);
  }
  s[0]=s[1];
  s[width-1]=s[width-2];
  string  s;
  s="./muschel/0.dat";
  file=new ofstream;
  file->open(s.c_str());
  if (*file==0) {
    system("PAUSE");
  }
  for (int i=0; i<width-1; i++) {
    *file << i<<", "<< a[i]<<", "<< b[i]<<", "<< s[i]<<endl;
  }
  delete file;
}

// hier Code zum Zeichnen
void simPlot() {
  for (int i=0; i<width; i++) {
    for (int j=0; j<20; j++) {
      float r=a[i]/1000.0;
      if (r>1) r=1;
      PlotSquare(i, j, 0.0, 0.0, r);
      r=b[i];
      if (r>1) r=1;
      PlotSquare(i, j+25, 0.0, 0.0, r);
    }
  }
}

// Speicher freigeben usw.
void simClean() {
  delete[] s;
  delete[] a;
  delete[] b;
  delete[] neua;
  delete[] neub;
}

//******************************************************************************
//******************************************************************************








void init(){
   glutReshapeWindow(4*width+20,4*height+20);
}

void PlotSquare (float x, float y, float r, float g, float b) {
  float faktor=4.0;
  glBegin(GL_QUADS); // Quadrat zeichnen
  	glColor3f(r,g,b);
  	glVertex2d(faktor*(x-(0.5)), faktor*(y+(0.5))); // Top Left
  	glVertex2d(faktor*(x-(0.5)), faktor*(y-(0.5))); // Top Right
  	glVertex2d(faktor*(x+(0.5)), faktor*(y-(0.5))); // Bottom Right
  	glVertex2d(faktor*(x+(0.5)), faktor*(y+(0.5))); // Bottom Left
  glEnd(); 
}

void display(void)
{
  //Freigabe des Farb- und Tiefenpuffers
  if (simulate) {
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  	simPlot(); 	

    glFlush();
    glutSwapBuffers ();
  }
}




/***************************************** myGlutIdle() ***********/

void myGlutIdle( void )
{
  // display() aufrufen. Dort Anzeigeroutine
  if ( glutGetWindow() != main_window ) 
    glutSetWindow(main_window);  

  glutPostRedisplay();
}    


void newFloatEdit(GLUI *gluiwin, char* name, float * var, float value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_FLOAT, var);
  edit1->set_float_val(value);
  *var =value;
}

void newIntEdit(GLUI *gluiwin, char* name, int* var, int value) {
  GLUI_EditText *edit1 = gluiwin->add_edittext(name, GLUI_EDITTEXT_INT, var);
  edit1->set_int_val(value);
  *var =value;
}

void newButton(GLUI *gluiwin, char* name, int id, GLUI_Update_CB callback) {
  GLUI_Button *button = gluiwin->add_button(name, id, callback);
}

void newColumn(GLUI *gluiwin){
  gluiwin->add_column(true);
}

void newSeparator(GLUI *gluiwin){
  gluiwin->add_separator();
}

void timer(int value) {
  if (simulate) {
    stepcount++;
    simStep();
    glutTimerFunc( 10, timer, 0);
  }
}


void buttonPressed (int id) {
  switch (id) {
    case 0: {
      // Start
      stepcount=0;
      if (clean) simClean();
      simInit();
      clean=true;
      init();
      simulate=true;
      glutTimerFunc( 10, timer, 0);
      break;
    }
    case 1: {
      // Stop
      simulate=false;
      break;
    }
    case 2: {
      // Go On
      simulate=true;
      glutTimerFunc( 10, timer, 0);
      break;
    }
  }
}

void reshape (int w, int h)
{
  glClearColor (1.0, 1.0, 1.0, 0.0);	//Hintergrundfarbe
  glViewport (0, 0, (GLsizei) w, (GLsizei) h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluOrtho2D (0.0, (GLdouble) w+20, 0.0, (GLdouble) h+20);
}


/**************************************** main() ********************/

int main(int argc, char* argv[])
{  


  simulate=false;
  clean=false;
  srand(static_cast<unsigned>(time(NULL)));
  
  glutInit(&argc, argv);
  
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH );
  glutInitWindowPosition( 350, 50 );
  glutInitWindowSize( 500, 500 );
 
  main_window = glutCreateWindow( "Reactive Lattice Gas Automata" );
  glutDisplayFunc( display );
  glutIdleFunc( myGlutIdle );
  glutReshapeFunc( reshape );
 
 
  //Erstellung des Eingabefensters mit Hilfe von glui

  GLUI *glui= GLUI_Master.create_glui ("Eingabefenster", 0, 50, 50);
  glui->set_main_gfx_window(main_window);
  
  newIntEdit(glui, "width =", &width, 250);
  newSeparator(glui);
  newFloatEdit(glui, "a = ", &starta, 1.0);
  newFloatEdit(glui, "b = ", &startb, 1.0);
  newFloatEdit(glui, "s = ", &starts, 0.0015);
  newFloatEdit(glui, "variation_s [%] = ", &variation, 1.0);
  newSeparator(glui);
  newFloatEdit(glui, "Da = ", &Da, 0.004);
  newFloatEdit(glui, "Db = ", &Db, 0.4);
  newSeparator(glui);
  newFloatEdit(glui, "ra = ", &ra, 0.0015);
  newFloatEdit(glui, "ba = ", &ba, 0.0001);
  newFloatEdit(glui, "rb = ", &rb, 0.0025);
  newSeparator(glui);
  newFloatEdit(glui, "dt = ", &dt, 1.0);
  
  newColumn(glui);
  newButton(glui, "Start", 0, buttonPressed);
  newButton(glui, "Stop", 1, buttonPressed);
  newButton(glui, "Go On", 2, buttonPressed);
  
  init();

  glutMainLoop();
  
  return 0;
}



