{-------------------------------------------------------------------------------
Author:      Jan Krieger, Ismaning (Munich), Germany
             jan@jkrieger.de
             http://www.jkrieger.de/
Date:        June 10./11. 2000
Name:        unit rtf10;
Version:     1.0
Copyright:   (c) 2000 by Jan W. Krieger. All rights reserved.
Description: unit with procedures to save text data as RichText-Files (*.rtf)
             (may be read by MS WORD and other wordprocessors)
Status:      This unit is FREEWARE, so no support can be granted
             Everybody may feel free to copy and use it.
             If you alter the sourcecode, it would be kind to send me the
             new source!

--------------------------------------------------------------------------------
                   This comment may not be deleted !!!
--------------------------------------------------------------------------------}

unit rtf10;

interface

uses classes,SysUtils, JKEStructs;

type tRTFUnderline=(strike,doublestrike,dot,dash,dotdash,dotdotdash,double,thick,wave,normal);
     tRTFUlStyle=(ULcontinuous,ULword,ULnone);
     tRTFCharStyle=(norm,caps,smallcaps);

procedure RTFOpen(fname,title,author:string);
// creates a new RTF-file with title and author
procedure RTFClose;
// closes a RTF file
procedure RTFWrite(text:string);
// writes text into rtf-file
procedure RTFWriteln(text:string);
// writes text into rtf-file and adds a linebreak
procedure RTFLineBreak;
// inserts a linebreak
procedure RTFResetStyles;
// resets all fontstyles
procedure RTFSetFont(fontname:string;size:integer);
// sets fontname and size, may not work
procedure RTFSetFontSize(size:integer);
// sets fontsize
procedure RTFSetAlign(align:tJKAlign);
// sets the alignment of a paragraph
procedure RTFSetFontStyle(fontstyle:tJKFontStyle);
// sets the fontstyle atributes
procedure RTFSetUnderline(Umode:tRTFUlStyle;line:tRTFUnderline);
// defines the underline of a text and switches underlinig on
procedure RTFNoUnderline;
// switches underlinig off
procedure RTFSetCharStyle(style:tRTFCharStyle);
// sets the characterstyles
procedure RTFWriteTab;
// writes a tabulator


var rtffonts:TStrings;

implementation

var rtff:system.text;
    rtf_underl:boolean;
    rtf_written:booleAN;

procedure RTFWriteTab;
begin
  Write(rtff,'\tab ');
end;

procedure RTFOpen(fname,title,author:string);
var i:longint;
begin
  assignfile(rtff,fname);
  rewrite(rtff);
  write(rtff,'{\rtf1\ansi\deff0');
  if rtffonts<>nil then if rtffonts.count>0 then begin
    Write(rtff,'{\fonttbl');
    for i:=0 to rtffonts.count-1 do
      Write(rtff,'{\f'+inttostr(i)+' '+rtffonts[i]+';');
    Write(rtff,'}');
  end;
  Write(rtff,'{\info');
  if author<>'' then Write(rtff,'{\author '+author+'}');
  if title<>'' then Write(rtff,'{\title '+title+'}');
  WriteLn(rtff,'}');
  rtf_underl:=false;
  rtf_written:=false;
end;

procedure RTFClose;
begin
  write(rtff,'}');
  closefile(rtff);
  rtf_written:=false;
end;

procedure RTFWrite(text:string);
begin
  Write(rtff,text);
  rtf_written:=true;
end;

procedure RTFWriteln(text:string);
begin
  WriteLn(rtff,text+'\par');
  rtf_written:=true;
end;

procedure RTFLineBreak;
begin
  WriteLn(rtff,'\par');
  rtf_written:=true;
end;

procedure RTFResetStyles;
begin
  RTFNoUnderline;
  Write(rtff,'\plain');
end;

procedure RTFSetFont(fontname:string;size:integer);
begin
  Write(rtff,'\f'+inttostr(rtffonts.indexof(fontname))+'\fs'+inttostr(size*2)+' ');
end;

procedure RTFSetFontSize(size:integer);
begin
  Write(rtff,'\fs'+inttostr(size*2)+' ');
end;

procedure RTFSetAlign(align:tJKAlign);
begin
  case align of
    alleft:write(rtff,'\ql');
    alright:write(rtff,'\qr');
    alcenter:write(rtff,'\qc');
    alblock:write(rtff,'\qj');
  end;
    write(rtff,' ');
end;

procedure RTFSetFontStyle(fontstyle:tJKFontStyle);
begin
  RTFResetStyles;
  if bold in fontstyle then write(rtff,'\b');
  if italic in fontstyle then write(rtff,'\i');
  if shadow in fontstyle then write(rtff,'\shad');
  if hidden in fontstyle then write(rtff,'\v');
  if underlined in fontstyle then write(rtff,'\ul');
  if sstrike in fontstyle then write(rtff,'\strike');
  if super in fontstyle then write(rtff,'\super ');
  if sub in fontstyle then write(rtff,'\sub ');
  write(rtff,' ');
end;

procedure RTFSetUnderline(Umode:tRTFUlStyle;line:tRTFUnderline);
begin
  write(rtff,'\ul0');
  if UMode=Ulnone then write(rtff,'\ul0');
  if UMode=Ulcontinuous then write(rtff,'\ul');
  if UMode=Ulword then write(rtff,'\ulw');
  case line of
    strike:write(rtff,'\strike');
    doublestrike:write(rtff,'\strikedl');
    dot:write(rtff,'\uld');
    dotdotdash:write(rtff,'\uldashdd');
    dash:write(rtff,'\uldash');
    double:write(rtff,'\uldb');
    dotdash:write(rtff,'\uldashd');
    wave:write(rtff,'\ulwave');
    thick:write(rtff,'\ulth');
    normal:write(rtff,'\ul');
  end;
    write(rtff,' ');
end;

procedure RTFNoUnderline;
begin
  if rtf_underl then write(rtff,'\ul0');
  rtf_underl:=false;
end;

procedure RTFSetCharStyle(style:tRTFCharStyle);
begin
  case style of
    caps:write(rtff,'\caps');
    smallcaps:write(rtff,'\scaps');
  end;
end;



end.
