unit jkClasses;
{
  (c) 2003 by Jan Krieger (jan@jkrieger.de - www.jkrieger.de)

  This unit is FREEWARE, so no warranties of any kind can be made!
  Please don't remove the name of the author.

  zustzliche Grundklassen (Listen ...)
}
interface

uses
  sysutils;



  {
    TjkMap speichert eine Liste von Pointern mit zugehrigen Schlsseln (strings)
    Funktioniert also so hnlich, wie TList, allerdings mit Strings als Schlsseln
  }
type
  EjkListError= class(Exception);
const
  SjkListCapacityError = 'capacity of list has exceeded (%d)';
  SjkListIndexError    = 'index out of range (%d)';
  SjkListNoMember      = 'index is not a member of this list';
  SjkListMultipleIndex = 'index already exists';
  SjkListCountError    = 'too many list entries (%d)';
type
  pjkMapItem=^tjkMapItem;
  tjkMapItem=record
    data:pointer;
    id:string[255];
  end;
const
  jkMapMaxListSize = Maxint div sizeof(pjkMapItem);
type
  PjkMapList = ^TjkMapList;
  TjkMapList = array[0..jkMapMaxListSize - 1] of tjkMapItem;
  TjkMap=class(TObject)
  private
    FCount,
    FCapacity: longint;
    FList: PjkMapList;
    FAutoInsert: boolean;
    FOwnsItems:boolean;
    function getItem(index: string): Pointer;
    procedure SetItem(index: string; value: pointer);
    function GetCount: longint;
  protected
    procedure SetCapacity(size: Integer);
    procedure Error(text: string; value: Integer);
    procedure SetCount(size: Integer);
  public
    constructor create;
    destructor destroy;
    procedure Clear;
    function ItemByNum(index: Integer): tjkMapItem;
    function ItemExists(index: string): boolean;
    procedure delete(index: string); overload;
    procedure Delete(index: Integer); overload;
    function IndexOf(index: string): longint;
    procedure Add(index: string; value: pointer);

    property Items[index:string]:Pointer read GetItem write SetItem; default;
    property Count:longint read GetCount;
    property AutoInsert:boolean read FAutoInsert write FAutoInsert;  //gibt an, ob bei einem Zugriff auf Items ein nicht vorhandenes Element automatisch eingefgt wird
    property OwnsItems:boolean read FOwnsItems write FOwnsItems;

  end;

implementation

procedure TjkMap.Add(index: string; value: pointer);
var i:longint;
begin
  i:=IndexOf(index);
  if i>=0 then error(SjkListMultipleIndex, 0)
  else begin
    if FCount = FCapacity then
      SetCapacity(FCapacity + 16);
    FList^[FCount].data:=value;
    FList^[FCount].id:=index;
    Inc(FCount);
  end;
end;

procedure TjkMap.Clear;
begin
  SetCount(0);
  SetCapacity(0);
end;

constructor TjkMap.create;
begin
  inherited create;
  AutoInsert:=true;
  OwnsItems:=true;
  FList:=nil;
  FCount:=0;
  Clear;
end;

procedure TjkMap.delete(index: string);
var i:longint;
begin
  i:=IndexOf(index);
  if i<0 then error(SjkListNoMember, 0)
  else delete(i);
end;

procedure TjkMap.Delete(index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then
    Error(SjkListIndexError, Index);
  if ownsitems then dispose(FList^[Index].data);
  Dec(FCount);
  if Index < FCount then  begin
    System.Move(FList^[Index + 1], FList^[Index], (FCount - Index) * SizeOf(tjkMapItem));
  end;
end;

destructor TjkMap.destroy;
begin
  Clear;
  inherited destroy;
end;

procedure TjkMap.Error(text: string; value: Integer);
begin
  raise EjkListError.CreateFmt(text, [value]);
end;

function TjkMap.GetCount: longint;
begin result:=FCount; end;

function TjkMap.getItem(index: string): Pointer;
var i:longint;
begin
  result:=nil;
  i:=IndexOf(index);
  if i<0 then error(SjkListNoMember, 0)
  else result:=FList^[i].data;
end;

function TjkMap.IndexOf(index: string): longint;
var i:longint;
begin
  i:=0;
  result:=-1;
  while i<FCount do begin
    if FList^[i].id=index then begin
      result:=i;
      i:=FCount;
    end;
    inc(i);
  end;
end;

function TjkMap.ItemByNum(index: Integer): tjkMapItem;
begin
  if (Index < 0) or (Index >= FCount) then
    Error(SjkListIndexError, Index);
  Result:=tjkMapItem(FList^[index])
end;

function TjkMap.ItemExists(index: string): boolean;
begin result:=(IndexOf(index)>=0); end;

procedure TjkMap.SetCapacity(size: Integer);
begin
  if (size<FCount)or(size > jkMapMaxListSize) then
    Error(SjkListCapacityError, size);
  if size <> FCapacity then begin
    ReallocMem(FList, size * SizeOf(tjkMapItem));
    if size=0 then FList:=nil;
    FCapacity := size;
  end;
end;

procedure TjkMap.SetCount(size: Integer);
var i: longint;
begin
  if (size < 0) or (size > jkMapMaxListSize) then
    Error(SjkListCountError, size);
  if size > FCapacity then
    SetCapacity(size);
  if size > FCount then begin
    FillChar(FList^[FCount], (size - FCount) * SizeOf(tjkMapItem), 0);
  end else
    for I := FCount - 1 downto size do
      Delete(I);
  FCount := size;
end;

procedure TjkMap.SetItem(index: string; value: pointer);
var i:longint;
begin
  i:=IndexOf(index);
  if i<0 then begin
    if FAutoInsert then begin
      Add(index, value);
    end else error(SjkListNoMember, 0);
  end else FList^[i].data:=value;
end;

end.
