program parsertest;
{$APPTYPE CONSOLE}
uses
  sysutils,
  math,
  JKErrorCalculation,
  jkMathParser in '..\jkMathParser.pas',
  jkClasses in '..\jkClasses.pas';


var s:string;
    parser:TjkMathParser;

procedure Hallo;
begin
  writeln('Taschenrechner mit Fehlerrechnung v1.0');
  writeln('  (c) 2003 by Jan Krieger (jan@jkrieger.de  http://www.jkrieger.de/)');
  writeln('');
  writeln('Kurzanleitung:');
  writeln('  - Zahlenformate: 3.3E-5 = 3.3*10^(-5)      Hex-Zahlen: $55FF');
  writeln('  - fehlerbehaftete Zahlen: {<Zahl>, <Fehler>}   Bsp: {3, 0.2} = 3 +/-0.2');
  writeln('  - Operatoren: +, -, *, /, ^(Potenz), !(Fakultt), %(Modulo-Division)');
  writeln('  - Absolut-Betrag: |<Ausdruck>|');
  writeln('  - Zuweisungen: a=<Ausdruck>');
  writeln('  - Trennzeichen zwischen zwei Anweisungen: ";"');
  writeln('  - mathematische Konstanten: Pi, e');
  writeln('  - physikalische Konstanten: m_alpha, m_alpha_u, at_unit, avogadro, boltzmann,'#13#10+
          '         boltzmann_ev, efield, m_e, m_e_u, elem_charge, g_norm, g_hd, faraday,'#13#10+
          '         gasconst, gravity, c_light, m_neutron, m_neutron_u, v_norm, planck,'#13#10+
          '         planck_ev, m_proton, m_proton_u, stefan_boltzmann, m_earth, r_earth'#13#10+
          '         m_sun, r_sun, m_moon, r_moon, density_h2o, density_ait');
  writeln('  - Funktionen: sqr, sqrt, exp, ln, log10=log=lg, log2=lb, abs, random=rnd,'#13#10+
          '         randomint=rndint, arccos, arcsin, arctan, arccosh, arcsinh, arctanh,'#13#10+
          '         cos, sin, tan, cot, cosh, sinh, tanh, ceil, floor, round, frac, int,'#13#10+
          '         sgn, error, relativeerror=relerror,'#13#10+
          '         logn(N, ex), randg=randomg(Mean, StdDev), hypot(X, Y), min(x,y), '#13#10+
          '         max(x,y)');
  writeln('  - Programmende: "end"          Hilfe: "help"');
end;

begin
  parser:=TjkMathParser.create;
  s:='';
  Hallo;
  repeat
    write('> ');
    readln(s);
    //start:=getTickCount;
    if (ansilowercase(s)<>'end')and(ansilowercase(s)<>'help') then  writeln('  = '+floattostr(parser.Parse(s)));
    if ansilowercase(s)='help' then hallo;
    //writeln('  time:  '+inttostr(getTickCount-start)+' ms');
  until (s='end');
  parser.free;
end.